/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.eventlog;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.Persistence;
import com.inet.shared.statistics.StatisticsPlugin;
import com.inet.shared.statistics.api.filter.Filter;
import com.inet.shared.statistics.api.filter.SelectFilter;
import com.inet.shared.statistics.api.table.StatisticsTable;
import com.inet.shared.statistics.api.table.TableData;
import com.inet.shared.statistics.eventlog.EventLogColumnDescription;
import com.inet.shared.statistics.eventlog.EventLogDescription;
import com.inet.usersandgroups.UsersAndGroups;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public class EventLogDataTable
extends StatisticsTable {
    public static final String USER_MANAGER_ACCESS = "hasUserManagerAccess";
    public static final String CONFIGURATION_ACCESS = "hasConfigurationAccess";
    private static final MemoryStoreMap<EventLogDataTable, HashSet<SelectFilter.LocalizedOption>[]> L = new MemoryStoreMap(60, true);
    private final EventLogDescription M;
    private EventLogPersistence N;

    public EventLogDataTable(@Nonnull EventLogDescription description) {
        this.M = description;
    }

    @Override
    public String getTitle() {
        return this.M.getTitle();
    }

    @Nonnull
    public String getExtensionName() {
        return "eventlog." + this.M.getExtensionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Filter> getFilters() {
        HashSet[] hashSetArray;
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        List<EventLogColumnDescription> list = this.M.getAllColumns();
        for (int i = 0; i < 1000 && L.get((Object)this) == null; ++i) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                return arrayList;
            }
        }
        EventLogDataTable eventLogDataTable = this;
        synchronized (eventLogDataTable) {
            if (L.get((Object)this) == null) {
                this.getData((Map)null);
            }
            hashSetArray = (HashSet[])L.get((Object)this);
        }
        for (int i = 0; i < hashSetArray.length; ++i) {
            if (hashSetArray[i] == null) continue;
            ArrayList<SelectFilter.LocalizedOption> arrayList2 = new ArrayList<SelectFilter.LocalizedOption>();
            for (SelectFilter.LocalizedOption localizedOption3 : hashSetArray[i]) {
                arrayList2.add(localizedOption3);
            }
            arrayList2.sort((localizedOption, localizedOption2) -> String.CASE_INSENSITIVE_ORDER.compare(localizedOption.getDisplayName(), localizedOption2.getDisplayName()));
            arrayList2.add(0, new SelectFilter.LocalizedOption("statistics.entry.eventlog.all", StatisticsPlugin.MSG.getMsg("statistics.entry.eventlog.all", new Object[0])));
            EventLogColumnDescription eventLogColumnDescription = list.get(i);
            arrayList.add(new SelectFilter(eventLogColumnDescription.getKey() + ".filter", eventLogColumnDescription.getTitle(), "statistics.entry.eventlog.all", arrayList2));
        }
        return arrayList;
    }

    @Override
    public synchronized TableData getData(Map<String, String> filterSettings) {
        HashSet[] hashSetArray;
        TableData tableData = this.createHeader();
        tableData.setSort(new TableData.TableSort("statistics.entry.date", true));
        List<EventLogColumnDescription> list = this.M.getAllColumns();
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = Math.max(n2, list.get(i).getSourceColumnIdx() + 1);
        }
        String[] stringArray = new String[n];
        boolean bl = true;
        if (filterSettings != null) {
            for (int i = 0; i < n; ++i) {
                String string = filterSettings.get(list.get(i).getKey() + ".filter");
                if (string == null || "statistics.entry.eventlog.all".equals(string)) continue;
                stringArray[i] = string;
                bl = L.get((Object)this) == null;
            }
        }
        if (bl) {
            hashSetArray = new HashSet[n];
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).isFiltered()) continue;
                hashSetArray[i] = new HashSet();
            }
        } else {
            hashSetArray = null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(USER_MANAGER_ACCESS, SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS));
        hashMap.put(CONFIGURATION_ACCESS, SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION));
        if (this.N == null) {
            this.N = Persistence.getInstance().getEventLogPersistence(this.M.getExtensionName());
        }
        try {
            Iterator iterator = this.N.getEvents(n2);
            ArrayDeque<TableData.TableCell[]> arrayDeque = new ArrayDeque<TableData.TableCell[]>();
            block7: while (iterator.hasNext()) {
                int n3 = -1;
                try {
                    String[] throwable = (String[])iterator.next();
                    TableData.TableCell[] tableCellArray = new TableData.TableCell[n];
                    for (int i = 0; i < n; ++i) {
                        n3 = i;
                        EventLogColumnDescription eventLogColumnDescription = list.get(i);
                        TableData.TableCell<?> tableCell = eventLogColumnDescription.getCellValue(throwable, hashMap);
                        if (bl && hashSetArray[i] != null && hashSetArray[i].size() < 1000) {
                            hashSetArray[i].add(eventLogColumnDescription.getFilterValue(tableCell));
                        }
                        if (stringArray[i] != null && !stringArray[i].equals(tableCell.getKey())) continue block7;
                        tableCellArray[i] = tableCell;
                    }
                    arrayDeque.add(tableCellArray);
                    if (arrayDeque.size() <= 1000) continue;
                    arrayDeque.removeFirst();
                }
                catch (Throwable throwable) {
                    StatisticsPlugin.LOGGER.debug(this.M.getExtensionName() + " at column " + n3 + " ", (Object)throwable);
                }
            }
            for (TableData.TableCell[] tableCellArray : arrayDeque) {
                tableData.addRow(tableCellArray);
            }
        }
        catch (Exception exception) {
            StatisticsPlugin.LOGGER.error((Throwable)exception);
        }
        if (bl) {
            L.put((Object)this, (Object)hashSetArray);
        }
        return tableData;
    }

    public TableData createHeader() {
        List<EventLogColumnDescription> list = this.M.getAllColumns();
        TableData.TableHeader[] tableHeaderArray = new TableData.TableHeader[list.size()];
        for (int i = 0; i < tableHeaderArray.length; ++i) {
            EventLogColumnDescription eventLogColumnDescription = list.get(i);
            TableData.ColumnType columnType = eventLogColumnDescription.getColumnType();
            String string = columnType == TableData.ColumnType.details ? null : eventLogColumnDescription.getKey();
            tableHeaderArray[i] = new TableData.TableHeader(columnType, string, eventLogColumnDescription.getTitle());
        }
        return new TableData(tableHeaderArray);
    }
}

