/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.eventlog;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.lib.util.StringFunctions;
import com.inet.shared.statistics.api.filter.SelectFilter;
import com.inet.shared.statistics.api.table.TableData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@InternalApi
public class EventLogColumnDescription {
    private static final Map<Locale, DateTimeFormatter> G = new ConcurrentHashMap<Locale, DateTimeFormatter>();
    public static final int DATETIME = 0;
    public static final int CAMELCASE = 1;
    public static final int STRING = 2;
    public static final int DETAILS = 3;
    public static final int NUMBER = 4;
    public static final int CAMELCASE_FILTERED = 257;
    public static final int STRING_FILTERED = 258;
    public static final int NUMBER_FILTERED = 260;
    private final int H;
    private final boolean I;
    private final I18nMessages J;
    private final String key;
    private final int K;

    public EventLogColumnDescription(@Nonnull I18nMessages i18n, @Nonnull String key, int type, int sourceColumnIdx) {
        this.J = i18n;
        this.key = key;
        this.H = type & 0xFFFFFEFF;
        this.I = (type & 0x100) > 0;
        this.K = sourceColumnIdx;
    }

    @Nonnull
    public TableData.ColumnType getColumnType() {
        switch (this.H) {
            case 0: 
            case 4: {
                return TableData.ColumnType.number;
            }
            case 3: {
                return TableData.ColumnType.details;
            }
        }
        return TableData.ColumnType.string;
    }

    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getTitle() {
        return this.J.getMsg(this.key, new Object[0]);
    }

    public boolean isFiltered() {
        return this.I;
    }

    public int getSourceColumnIdx() {
        return this.K;
    }

    public TableData.TableCell<?> getCellValue(String[] line, @Nonnull Map<String, Object> states) {
        String string = line[this.K];
        switch (this.H) {
            case 0: {
                Instant instant = DateTimeFormatter.ISO_INSTANT.parse((CharSequence)string, Instant::from);
                long l = instant.toEpochMilli();
                return new TableData.TableCell<Long>(l, EventLogColumnDescription.e().format(instant));
            }
            case 1: {
                return new TableData.TableCell<String>(string, EventLogColumnDescription.a(string));
            }
        }
        return new TableData.TableCell<String>(string);
    }

    public SelectFilter.LocalizedOption getFilterValue(@Nonnull TableData.TableCell<?> cellValue) {
        return new SelectFilter.LocalizedOption(cellValue.getKey().toString(), cellValue.getDisplayName());
    }

    @Nonnull
    private static DateTimeFormatter e() {
        Locale locale = ClientLocale.getThreadLocale();
        TimeZone timeZone = ClientTimezone.getTimeZone();
        DateTimeFormatter dateTimeFormatter = G.get(locale);
        if (dateTimeFormatter == null) {
            dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(locale).withZone(timeZone.toZoneId());
            G.put(locale, dateTimeFormatter);
        }
        return dateTimeFormatter;
    }

    @Nonnull
    static String a(String string) {
        int n;
        if (StringFunctions.isEmpty((String)string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = n = stringBuilder.length() - 1; i > 0; --i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            stringBuilder.insert(i, ' ');
        }
        return stringBuilder.toString();
    }
}

