/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.statistics.api.filter;

import com.inet.annotations.JsonData;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.shared.statistics.api.filter.Filter;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonData
public class SelectFilter
extends Filter {
    private List<LocalizedOption> options;

    public SelectFilter(String key, String label, String value, List<LocalizedOption> options) {
        super(key, Filter.TYPE.select, label, value);
        this.options = options;
    }

    public List<LocalizedOption> getOptions() {
        return this.options;
    }

    @JsonData
    public static class LocalizedOption
    implements DisplayableKey<String> {
        private String value;
        private String label;

        private LocalizedOption() {
        }

        public LocalizedOption(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getKey() {
            return this.value;
        }

        public String getDisplayName() {
            return this.label;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(this.value, ((LocalizedOption)obj).value) && Objects.equals(this.label, ((LocalizedOption)obj).label);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

