/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.pam;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.lib.core.OS;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepsExecutionListener;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.pam.ShadowFileChecker;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PamExecutionListener
implements SetupStepsExecutionListener {
    private ShadowFileChecker ak;
    private String al;
    private String am;
    private ServerPluginManager an;

    public PamExecutionListener(ShadowFileChecker shadowChecker, String productUserName, String productServiceName) {
        this(shadowChecker, productUserName, productServiceName, ServerPluginManager.getInstance());
    }

    public PamExecutionListener(ShadowFileChecker shadowChecker, String productUserName, String productServiceName, ServerPluginManager spm) {
        this.ak = shadowChecker;
        this.al = productUserName;
        this.am = productServiceName;
        this.an = spm;
    }

    @Override
    public void executionPhaseFinished(boolean serverWillRestart, List<StepKey> executedSteps) throws Exception {
        if (OS.isLinux() && this.ak.exists() && !this.ak.isReadable()) {
            if (this.mustAddPamWarning()) {
                StepExecutionWarnings.get().info(() -> this.t());
            } else {
                SetupLogger.LOGGER.info((Object)"[PAM] Login type is not pam");
            }
        }
    }

    protected boolean mustAddPamWarning() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PERMISSION_LOGINTYPE.getKey());
        return (string == null || string.equals("automatic") || string.equals("pam")) && this.an.isPluginLoaded("authentication.pam");
    }

    private synchronized String s() {
        Path path = Paths.get("enable-pam-for-user.sh", new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return path.toAbsolutePath().toString();
        }
        URL uRL = PamExecutionListener.class.getResource("enable-pam-for-user.sh");
        try (FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());
             InputStream inputStream = uRL.openStream();){
            IOFunctions.copyData((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return path.toAbsolutePath().toString();
    }

    private String t() {
        String string = this.u();
        string = this.j(string);
        string = this.i(string);
        return string;
    }

    private String i(String string) {
        String string2 = this.s();
        string = string.replace("[scriptFilePath]", string2);
        string = string.replace("[productServiceName]", this.am);
        string = string.replace("[productUserName]", System.getProperty("user.name"));
        string = string.replace("[shadowFilePath]", "<code>/etc/shadow</code>");
        return string;
    }

    private String j(String string) {
        Pattern pattern = Pattern.compile("\\{\\{([^\\}\\{]+)\\}\\}");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            string = string.replace(string2, StringFunctions.encodeHTML((String)SetupWizardPlugin.MSG.getMsg(matcher.group(1), new Object[0])));
        }
        return string;
    }

    private String u() {
        String string;
        block9: {
            URL uRL = PamExecutionListener.class.getResource("PamMessage.html");
            InputStream inputStream = uRL.openStream();
            try {
                int n;
                int n2 = 1024;
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) >= 0) {
                    stringBuilder.append(cArray, 0, n);
                }
                string = stringBuilder.toString();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

