/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.license;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseInfoHolder;
import com.inet.plugin.ApplicationDescription;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfig;
import com.inet.shared.utils.Version;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class LicenseStepConfigChecker {
    public static final int LICENSE_INVALID = 1;
    public static final int LICENSE_VALID_TRIAL = 2;
    public static final int LICENSE_VALID_OTHER = 3;

    public SetupStepProblems findProblemsWithConfig(LicenseStepConfig stepConfig) {
        if (stepConfig == null) {
            throw new IllegalArgumentException("step config must not be null");
        }
        SetupStepProblems setupStepProblems = new SetupStepProblems();
        if (stepConfig.licenseKey() == null || stepConfig.licenseKey().isEmpty()) {
            if (this.isMissingLicenseAnError()) {
                setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("license.noValidLicenseKey", new Object[0]));
            } else {
                setupStepProblems.addWarning(SetupWizardPlugin.MSG.getMsg("license.noValidLicenseKey", new Object[0]));
            }
            return setupStepProblems;
        }
        LicenseInfoHolder licenseInfoHolder = new ConfigKeyParser().getLicenseInfo(stepConfig.licenseKey());
        if (!stepConfig.isIncludedInConfiguration()) {
            if (licenseInfoHolder.getAll().size() > 1) {
                setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("license.expectedOnlyOneLicenseKey", new Object[0]));
            }
            if (!(var4_4 = licenseInfoHolder.getCurrent()).isValid()) {
                setupStepProblems.addError(var4_4.getErrorMessage());
            }
        } else {
            var4_4 = licenseInfoHolder.getCurrent();
            boolean bl = var4_4.isValid();
            if (!bl) {
                setupStepProblems.addError(var4_4.getErrorMessage());
            }
        }
        if (stepConfig.isTrialLicense()) {
            long l = 0L;
            Date date = this.a(licenseInfoHolder.getCurrent());
            if (date != null) {
                l = (date.getTime() - System.currentTimeMillis()) / 1000L / 60L / 60L / 24L + 1L;
            }
            setupStepProblems.addWarning(this.getTrialWarning(l));
        }
        return setupStepProblems;
    }

    protected String getTrialWarning(long days) {
        return SetupWizardPlugin.MSG.getMsg("license.trialLicenseWarning", new Object[]{days});
    }

    protected boolean isMissingLicenseAnError() {
        return false;
    }

    private Date a(@Nonnull LicenseInfo licenseInfo) {
        try {
            String string = (String)licenseInfo.getAttributes().get("expires");
            return new SimpleDateFormat("yyyy-MM-dd").parse(string);
        }
        catch (Exception exception) {
            SetupLogger.LOGGER.debug((Object)exception);
            return null;
        }
    }

    public boolean containsAtLeastOneValidLicenseKey() {
        if (ConfigKeyParser.getCurrent().isValid()) {
            return true;
        }
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        String string = applicationDescription.getApplicationName();
        String string2 = (String)ConfigKey.LICENSEKEY.getCurrent();
        List list = new ConfigKeyParser().getLicenseInfo(string2).getAll();
        for (LicenseInfo licenseInfo : list) {
            if (licenseInfo.hasExpiredDate() && java.sql.Date.valueOf((String)licenseInfo.getAttributes().get("expires")).before(new Date(System.currentTimeMillis() - 86400000L)) || !Objects.equals(string, licenseInfo.getAttributes().get("app"))) continue;
            String string3 = (String)licenseInfo.getAttributes().get("version");
            if (string3 != null) {
                if (new Version(string3).getMajor() < applicationDescription.getVersion().getMajor()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public int whatLicenseIs(String licenseKey) {
        LicenseInfo licenseInfo = new ConfigKeyParser().getLicenseInfo(licenseKey).getCurrent();
        if (licenseInfo.isValid()) {
            return licenseInfo.isTrial() ? 2 : 3;
        }
        return 1;
    }

    public String getFirstValidLicenseKey(String licenseKeys) {
        if (licenseKeys == null) {
            return null;
        }
        LicenseInfoHolder licenseInfoHolder = new ConfigKeyParser().getLicenseInfo(licenseKeys);
        LicenseInfo licenseInfo = licenseInfoHolder.getCurrent();
        if (licenseInfo.isValid()) {
            return (String)licenseInfo.getAttributes().get("key");
        }
        return null;
    }
}

