/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.execution.chain;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.globalbanner.GlobalBanner;
import com.inet.globalbanner.GlobalBannerManager;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.setupwizard.a;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepsExecutionListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.b;
import com.inet.setupwizard.execution.PostExecutionInfos;
import com.inet.setupwizard.execution.StepExecutionWarningsImpl;
import com.inet.setupwizard.execution.c;
import com.inet.setupwizard.f;
import com.inet.setupwizard.servicemethods.e;
import com.inet.shared.utils.Version;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class ExecutionChainCtrl
implements ServerPluginManagerListener,
SetupStepsExecutionListener {
    public static final ConfigKey SETUP_CHAIN_KEY = new ConfigKey("setupChain", null, String.class);
    public static final ConfigKey SETUP_EXECUTED_STEPS_KEY = new ConfigKey("setupExecutedSteps", null, String.class);
    private static final ConfigValue<HashSet<String>> aQ = new ConfigValue<HashSet<String>>(SETUP_EXECUTED_STEPS_KEY){

        protected HashSet<String> p(@Nonnull String string) throws IllegalArgumentException {
            if (string.isEmpty()) {
                return new HashSet<String>();
            }
            return (HashSet)new Json().fromJson(string, HashSet.class);
        }

        protected void setValue(String strValue) throws IllegalArgumentException {
            if (strValue == null) {
                super.setValue("");
            } else {
                super.setValue(strValue);
            }
        }

        protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
            return this.p(string);
        }
    };
    @Deprecated
    public static final ConfigKey SETUP_LAST_MIGRATED_VERSION = new ConfigKey("lastMigratedVersion", null, Version.class);
    @Deprecated
    public static final ConfigValue<Version> LAST_MIGRATED_VERSION = new ConfigValue<Version>(SETUP_LAST_MIGRATED_VERSION){};
    public static final ConfigValue<Map<String, String>> LAST_MIGRATED_PLUGIN_VERSIONS = new ConfigValue<Map<String, String>>(ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS){

        protected void setValue(String strValue) throws IllegalArgumentException {
            if (strValue == null) {
                strValue = "{}";
            }
            super.setValue(strValue);
        }
    };
    public static final String FALLBACK_PLUGIN_ID = "inetcore";
    private StepsRepository b;
    private a o;
    private b m;
    private e aR;
    private f p;
    private SetupExecutionChain aS;
    private GlobalBannerManager aT;
    private boolean aU = false;
    private volatile boolean aV = false;
    private c a;
    private com.inet.setupwizard.execution.pluginupdate.a q;
    private com.inet.setupwizard.remotemodule.a aW = new com.inet.setupwizard.remotemodule.a();

    public void init(StepsRepository repository, a autoExecutor, b setupLogfileLogger, e uuidChecker, f setupWizardVetoPower, c executor, com.inet.setupwizard.execution.pluginupdate.a pluginUpdateVeto, GlobalBannerManager globalBannerManager) {
        this.b = repository;
        this.o = autoExecutor;
        this.m = setupLogfileLogger;
        this.aR = uuidChecker;
        this.p = setupWizardVetoPower;
        this.a = executor;
        this.q = pluginUpdateVeto;
        this.aT = globalBannerManager;
    }

    public SetupExecutionChain getCURRENT() {
        this.Y();
        return this.aS;
    }

    private boolean c(boolean bl) {
        if (this.aS == null) {
            this.aS = this.W();
        }
        if (this.getAllActiveSteps(true).isEmpty()) {
            SetupLogger.LOGGER.info((Object)"[control] No Step needs execution, releasing veto.");
            this.p.g();
            this.aT.unregisterGlobalBanner(this.aW.getExtensionName());
            this.aS.uuids.clear();
            this.aS.executedSteps.clear();
            this.X();
            if (this.aS.activeSetup) {
                this.d(false);
                this.aS.activeSetup = false;
            }
            this.aS.save();
            if (bl) {
                SetupLogger.LOGGER.info((Object)"[control] No Setup-step need further actions - delete setup log file.");
                this.m.reset();
            } else {
                this.m.b();
            }
            return true;
        }
        if (!this.aS.activeSetup) {
            SetupLogger.LOGGER.info((Object)"[control] Start a new setup chain.");
            this.aS = new SetupExecutionChain();
        }
        this.aS.uuids.add(this.aR.ak());
        if (bl) {
            if (!ConfigurationManager.isHelpCenterMode()) {
                this.aT.registerGlobalBanner((GlobalBanner)this.aW);
            }
            this.V();
        }
        this.aS.save();
        this.o.a();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SetupStep<?>> getAllActiveSteps(boolean log) {
        this.Y();
        if (log) {
            SetupLogger.LOGGER.info((Object)"Check which steps need execution");
        }
        ArrayList arrayList = new ArrayList();
        List<SetupStep<?>> list = this.b.allSteps();
        Set<String> set = this.aS.executedSteps;
        for (SetupStep<?> setupStep : list) {
            block23: {
                String string;
                block21: {
                    block22: {
                        block17: {
                            block20: {
                                Version version;
                                Version version2;
                                block18: {
                                    block19: {
                                        string = "NO";
                                        version2 = setupStep.getMigrationVersion();
                                        if (version2 == null) break block17;
                                        version = setupStep.getLastMigratedVersionOfThisPlugin();
                                        if (version != null) break block18;
                                        string = "NOT_FOR_NEW_PLUGIN";
                                        if (!log) break block19;
                                        SetupLogger.LOGGER.info((Object)String.format("Step '%s' (key=%s) needs execution: %s", setupStep.getStepDisplayName(), setupStep.stepKey(), string));
                                    }
                                    if (!setupStep.stepKey().toString().equals("UpdatePluginsStep")) continue;
                                    if (arrayList.contains(setupStep)) {
                                        if (!log) break;
                                        SetupLogger.LOGGER.info((Object)String.format("Step '%s' is activated: there are plugins to update. All succeeding steps will be ignored and checked again after plugins has been updated.", setupStep.getStepDisplayName()));
                                        break;
                                    }
                                    this.q.ac();
                                    continue;
                                }
                                if (!version.isHigherOrEquals(version2)) break block17;
                                string = "NOT_FOR_THIS_VERSION";
                                if (!log) break block20;
                                SetupLogger.LOGGER.info((Object)String.format("Step '%s' (key=%s) needs execution: %s", setupStep.getStepDisplayName(), setupStep.stepKey(), string));
                            }
                            if (!setupStep.stepKey().toString().equals("UpdatePluginsStep")) continue;
                            if (arrayList.contains(setupStep)) {
                                if (!log) break;
                                SetupLogger.LOGGER.info((Object)String.format("Step '%s' is activated: there are plugins to update. All succeeding steps will be ignored and checked again after plugins has been updated.", setupStep.getStepDisplayName()));
                                break;
                            }
                            this.q.ac();
                            continue;
                        }
                        if (setupStep.getExecutionRestriction() != SetupStep.ExecutionRestriction.ONLY_ONCE || !((HashSet)aQ.get()).contains(setupStep.stepKey().toString())) break block21;
                        string = "ALREADY EXECUTED";
                        if (!log) break block22;
                        SetupLogger.LOGGER.info((Object)String.format("Step '%s' (key=%s) needs execution: %s", setupStep.getStepDisplayName(), setupStep.stepKey(), string));
                    }
                    if (!setupStep.stepKey().toString().equals("UpdatePluginsStep")) continue;
                    if (arrayList.contains(setupStep)) {
                        if (!log) break;
                        SetupLogger.LOGGER.info((Object)String.format("Step '%s' is activated: there are plugins to update. All succeeding steps will be ignored and checked again after plugins has been updated.", setupStep.getStepDisplayName()));
                        break;
                    }
                    this.q.ac();
                    continue;
                }
                try {
                    if (setupStep.hasPendingTasks()) {
                        if (set.contains(setupStep.stepKey().toString()) && setupStep.getExecutionRestriction() == SetupStep.ExecutionRestriction.ONCE_PER_SETUP) {
                            string = "YES - but was already executed in this setup";
                        } else {
                            string = "YES";
                            arrayList.add(setupStep);
                        }
                    }
                    if (!log) break block23;
                }
                catch (Throwable throwable) {
                    if (log) {
                        SetupLogger.LOGGER.info((Object)String.format("Step '%s' (key=%s) needs execution: %s", setupStep.getStepDisplayName(), setupStep.stepKey(), string));
                    }
                    if (setupStep.stepKey().toString().equals("UpdatePluginsStep")) {
                        if (arrayList.contains(setupStep)) {
                            if (!log) break;
                            SetupLogger.LOGGER.info((Object)String.format("Step '%s' is activated: there are plugins to update. All succeeding steps will be ignored and checked again after plugins has been updated.", setupStep.getStepDisplayName()));
                            break;
                        }
                        this.q.ac();
                    }
                    throw throwable;
                }
                SetupLogger.LOGGER.info((Object)String.format("Step '%s' (key=%s) needs execution: %s", setupStep.getStepDisplayName(), setupStep.stepKey(), string));
            }
            if (!setupStep.stepKey().toString().equals("UpdatePluginsStep")) continue;
            if (arrayList.contains(setupStep)) {
                if (!log) break;
                SetupLogger.LOGGER.info((Object)String.format("Step '%s' is activated: there are plugins to update. All succeeding steps will be ignored and checked again after plugins has been updated.", setupStep.getStepDisplayName()));
                break;
            }
            this.q.ac();
        }
        return arrayList;
    }

    protected void V() {
        Thread thread = new Thread(() -> {
            while (!this.p.h()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    SetupLogger.LOGGER.error((Throwable)interruptedException);
                }
                if (this.a.M() || this.aV || this.p.h()) continue;
                boolean bl = this.getAllActiveSteps(false).isEmpty();
                if (this.a.M() || this.aV || this.p.h() || !bl) continue;
                SetupLogger.LOGGER.info((Object)"[control] Thread: No Step needs execution");
                this.c(false);
            }
        }, "Setup Check Has Still pending Tasks");
        thread.setDaemon(true);
        thread.start();
    }

    public void executionDone(boolean willrestartServer, List<StepExecutionWarningsImpl.Entry> postExecutionInfos) {
        this.aS.postExecutionInfos.addAll(postExecutionInfos);
        this.aS.save();
        if (!willrestartServer) {
            this.c(false);
            this.aV = false;
        }
    }

    private void d(boolean bl) {
        List list = ServerPluginManager.getInstance().get(SetupStepsExecutionListener.class);
        for (SetupStepsExecutionListener setupStepsExecutionListener : list) {
            try {
                setupStepsExecutionListener.setupCompleted(bl);
            }
            catch (Exception exception) {
                SetupLogger.LOGGER.error((Throwable)exception);
            }
        }
        SetupLogger.LOGGER.info((Object)"[control] Notified setup completed listeners");
    }

    private SetupExecutionChain W() {
        String string = (String)SETUP_CHAIN_KEY.getCurrent();
        if (string == null) {
            SetupLogger.LOGGER.info((Object)"[control] No setup chain exists, starting new one.");
            return new SetupExecutionChain();
        }
        try {
            SetupExecutionChain setupExecutionChain = (SetupExecutionChain)new Json().fromJson(string, SetupExecutionChain.class, new HashMap());
            SetupLogger.LOGGER.info((Object)"[control] Loaded existing setup chain");
            return setupExecutionChain;
        }
        catch (JsonException jsonException) {
            SetupLogger.LOGGER.info((Object)"[control] Existing setup chain is not compatible, starting a new one");
            return new SetupExecutionChain();
        }
    }

    @Override
    public void executionStarted(List<StepKey> stepsToExecute) {
        this.aV = true;
        SetupExecutionChain setupExecutionChain = this.getCURRENT();
        setupExecutionChain.activeSetup = true;
        setupExecutionChain.save();
    }

    @Override
    public void executionPhaseFinished(boolean serverWillRestart, List<StepKey> executedSteps) throws Exception {
        this.i(executedSteps);
    }

    private void i(List<StepKey> list) {
        List list2 = list.stream().map(StepKey::toString).collect(Collectors.toList());
        this.aS.executedSteps.addAll(list2);
        HashSet hashSet = (HashSet)aQ.get();
        hashSet.addAll(list2);
        ConfigurationManager.getInstance().getCurrent().put(SETUP_EXECUTED_STEPS_KEY, new Json().toJson((Object)hashSet));
    }

    @Override
    public void executionFailed(String failingStepMessage, Throwable error, List<StepKey> executedSteps) {
        this.i(executedSteps);
        this.aS.save();
        this.aV = false;
    }

    public void initFinished() {
        if (this.b != null) {
            new Thread("Setup Wizard Init"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ExecutionChainCtrl.this.c(true);
                        ExecutionChainCtrl executionChainCtrl = ExecutionChainCtrl.this;
                        synchronized (executionChainCtrl) {
                            ExecutionChainCtrl.this.aU = true;
                            ExecutionChainCtrl.this.notifyAll();
                        }
                    }
                    catch (Throwable throwable) {
                        SetupLogger.LOGGER.fatal((Object)"[control] Setup Initialization faced a fatal problem. Probably a step threw an unexpected error. Setup cannot be executed if a step cannot determine whether it needs execution or not. See stacktrace below.");
                        SetupLogger.LOGGER.fatal((Object)throwable);
                        ExecutionChainCtrl.this.aU = false;
                        throw throwable;
                    }
                }
            }.start();
        }
    }

    private void X() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        HashMap<String, String> hashMap = new HashMap<String, String>((Map)LAST_MIGRATED_PLUGIN_VERSIONS.get());
        for (String string : serverPluginManager.getLoadedPlugins()) {
            String string2 = serverPluginManager.getPluginDescription(string).getVersionString();
            hashMap.put(string, string2);
        }
        configuration.put(ConfigKey.SETUP_LAST_MIGRATED_PLUGIN_VERSIONS.getKey(), new Json().toJson(hashMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Y() {
        if (this.aU || Thread.currentThread().getName().equals("Setup Wizard Init")) {
            return;
        }
        ExecutionChainCtrl executionChainCtrl = this;
        synchronized (executionChainCtrl) {
            if (!this.aU) {
                try {
                    SetupLogger.LOGGER.info((Object)"Wait for Server Initialization to complete");
                    this.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException(interruptedException);
                }
                if (!this.aU) {
                    try {
                        StringWriter stringWriter = new StringWriter(500);
                        ThreadUtils.threadDump((Writer)stringWriter);
                        SetupLogger.LOGGER.error((Object)stringWriter.toString());
                    }
                    catch (IOException iOException) {
                        SetupLogger.LOGGER.fatal((Object)iOException);
                    }
                    throw new IllegalStateException("Initialization of setup takes too long. See preceding thread dump and check what the 'Setup Wizard Init' is doing or check logfile for where it crashed.");
                }
            }
        }
    }

    public Set<String> getCurrentlyValidUUIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getCURRENT().getUuids());
        hashSet.add(this.aR.ak());
        return hashSet;
    }

    @JsonData
    public static class SetupExecutionChain {
        private List<String> uuids = new ArrayList<String>();
        private Set<String> executedSteps = new HashSet<String>();
        private PostExecutionInfos postExecutionInfos = new PostExecutionInfos();
        private Map<String, String> metaData = new HashMap<String, String>();
        private boolean activeSetup = true;

        public void save() {
            String string = new Json().toJson((Object)this);
            ConfigurationManager.getInstance().getCurrent().put(SETUP_CHAIN_KEY.getKey(), string);
        }

        public Map<String, String> getMetaData() {
            return this.metaData;
        }

        public PostExecutionInfos getPostExecutionInfos() {
            return this.postExecutionInfos;
        }

        public List<String> getUuids() {
            return this.uuids;
        }

        public List<String> getExecutedSteps() {
            return new ArrayList<String>(this.executedSteps);
        }

        public boolean performIrreversibleMigrationAcknowledged() {
            return this.getMetaData().containsKey("performIrreversibleMigration");
        }

        public void acknowledgeIrreversibleMigration() {
            this.getMetaData().put("performIrreversibleMigration", "true");
        }
    }
}

