/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigAdditionalData;

@JsonData
public class WebServerStepConfig
extends StepConfiguration {
    public static final String STANDALONE = "standalone";
    public static final String MICROSOFT_IIS = "iis";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    private String option = "";
    private String context = "";
    private String protocol = "";
    private String port;
    private WebServerStepConfigAdditionalData additionalData;
    private String serverUrl;
    private String serverHostName;

    public WebServerStepConfig() {
        this("", "");
    }

    public WebServerStepConfig(String option, String context, String protocol, int port, String serverHostName) {
        this(option, protocol);
        this.context = context;
        this.serverHostName = serverHostName;
        this.port = String.valueOf(port);
    }

    public WebServerStepConfig(String option, String protocol) {
        this.option = option;
        this.protocol = protocol;
        this.serverUrl = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.SERVER_URL.getKey());
    }

    public String option() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String context() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String protocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String port() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public WebServerStepConfigAdditionalData additionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(WebServerStepConfigAdditionalData additionalData) {
        this.additionalData = additionalData;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.additionalData == null ? 0 : this.additionalData.hashCode());
        n2 = 31 * n2 + (this.context == null ? 0 : this.context.hashCode());
        n2 = 31 * n2 + (this.option == null ? 0 : this.option.hashCode());
        n2 = 31 * n2 + (this.port == null ? 0 : this.port.hashCode());
        n2 = 31 * n2 + (this.protocol == null ? 0 : this.protocol.hashCode());
        n2 = 31 * n2 + (this.serverHostName == null ? 0 : this.serverHostName.hashCode());
        n2 = 31 * n2 + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebServerStepConfig webServerStepConfig = (WebServerStepConfig)obj;
        if (this.additionalData == null ? webServerStepConfig.additionalData != null : !this.additionalData.equals(webServerStepConfig.additionalData)) {
            return false;
        }
        if (this.context == null ? webServerStepConfig.context != null : !this.context.equals(webServerStepConfig.context)) {
            return false;
        }
        if (this.option == null ? webServerStepConfig.option != null : !this.option.equals(webServerStepConfig.option)) {
            return false;
        }
        if (this.port == null ? webServerStepConfig.port != null : !this.port.equals(webServerStepConfig.port)) {
            return false;
        }
        if (this.protocol == null ? webServerStepConfig.protocol != null : !this.protocol.equals(webServerStepConfig.protocol)) {
            return false;
        }
        if (this.serverHostName == null ? webServerStepConfig.serverHostName != null : !this.serverHostName.equals(webServerStepConfig.serverHostName)) {
            return false;
        }
        return !(this.serverUrl == null ? webServerStepConfig.serverUrl != null : !this.serverUrl.equals(webServerStepConfig.serverUrl));
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }
}

