/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.persistence.appdatawritable;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.BasicStepPriorities;
import com.inet.setupwizard.basicsteps.persistence.appdatawritable.AppDataStepConfig;
import com.inet.setupwizard.basicsteps.persistence.appdatawritable.CheckRestartedResponse;
import com.inet.setupwizard.basicsteps.persistence.appdatawritable.TriggerRestartResponse;
import com.inet.setupwizard.execution.serverrestart.c;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class CheckAppDataWritableStep
extends SetupStep<AppDataStepConfig> {
    public static final StepKey KEY = new StepKey("checkAppDataWritable");
    private boolean hasPendingTasks = false;
    private c ar;

    public CheckAppDataWritableStep(c serverRestarter) {
        this.ar = serverRestarter;
    }

    @Override
    public StepKey stepKey() {
        return KEY;
    }

    @Override
    public String getStepDisplayName() {
        return SetupWizardPlugin.MSG.getMsg("appdata.writable.displayname", new Object[0]);
    }

    @Override
    public boolean hasPendingTasks() {
        if (!(this.hasPendingTasks || this.isAppDataWritable() && this.z())) {
            this.hasPendingTasks = true;
        }
        return this.hasPendingTasks;
    }

    @Override
    public SetupStep.ExecutionRestriction getExecutionRestriction() {
        return SetupStep.ExecutionRestriction.ONLY_ONCE;
    }

    private boolean z() {
        if (this.getLastMigratedVersionOfThisPlugin() != null) {
            return true;
        }
        if (!Persistence.isFilePersistence()) {
            return true;
        }
        if (ConfigurationManager.getInstance().getCurrent().get(ConfigKey.APP_DATA_PATH.getKey()) != null) {
            return true;
        }
        Path path = ((FilePersistence)Persistence.getInstance()).getPersistenceFolder().toAbsolutePath();
        Path path2 = Paths.get("", new String[0]).toAbsolutePath();
        return path.getRoot().equals(path2.getRoot());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input possible here")
    protected boolean isAppDataWritable() {
        String string = ConfigKey.APP_DATA_PATH.getKey();
        String string2 = ConfigurationManager.getInstance().getCurrent().get(string);
        return this.isAppDataWritable(string2);
    }

    private String getCurrentAppDataPath() {
        Path path = ((FilePersistence)Persistence.getInstance()).getPersistenceFolder().toAbsolutePath();
        return path.toString();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input possible here")
    protected boolean isAppDataWritable(String appDataPath) {
        if (appDataPath != null) {
            try {
                Path path = Paths.get(appDataPath, new String[0]);
                if (!Files.isWritable(path) || !Files.isDirectory(path, new LinkOption[0])) {
                    return false;
                }
                Path path2 = path.resolve(ServerPluginManager.getInstance().getCorePluginId());
                if (!Files.notExists(path2, new LinkOption[0]) && !Files.isWritable(path2)) {
                    return false;
                }
            }
            catch (InvalidPathException invalidPathException) {
                SetupLogger.LOGGER.warn((Object)String.format("[CheckAppDataWritable] The set AppData Path is invalid: %s", appDataPath));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doesRequireToRestartServerAfterExecution(AppDataStepConfig stepConfig) {
        return false;
    }

    @Override
    public void execute(AppDataStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
    }

    @Override
    public SetupStepPriority getPriority() {
        return BasicStepPriorities.PERSISTENCE_WRITABLE;
    }

    @Override
    public InfoMessageGetter getExecutionInfoMessage(AppDataStepConfig stepConfig) {
        return () -> SetupWizardPlugin.MSG.getMsg("appdata.writable.executionMessage", new Object[0]);
    }

    @Override
    public AppDataStepConfig updateConfiguration(StepConfigurationStorage storage, StepsRepository repository, AppDataStepConfig stepConfig, StepKey changedStep) {
        if (stepConfig == null) {
            AppDataStepConfig appDataStepConfig = new AppDataStepConfig(!this.isAppDataWritable(), !this.z());
            appDataStepConfig.setCurrentAppDataPath(this.getCurrentAppDataPath());
            return appDataStepConfig;
        }
        return stepConfig;
    }

    @Override
    public SetupStepProblems findProblemsWithConfig(AppDataStepConfig stepConfig) {
        String string;
        SetupStepProblems setupStepProblems = new SetupStepProblems();
        String string2 = ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getApplicationName();
        if (stepConfig.isNotSameDrive()) {
            if (!stepConfig.isAcceptNotSameDrive()) {
                string = stepConfig.getNewAppDataPath();
                if (!StringFunctions.isEmpty((String)string) && this.isAppDataWritable(string)) {
                    stepConfig.setCanRestartNow(true);
                    setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("appdata.writable.restartToApplyNewPath", new Object[0]));
                    this.a(stepConfig, setupStepProblems);
                } else if (!StringFunctions.isEmpty((String)string)) {
                    stepConfig.setCanRestartNow(false);
                    setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("appdata.writable.newPathNotWritable", new Object[]{string}));
                } else {
                    stepConfig.setCanRestartNow(false);
                    setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("appdata.writable.notSameDriveMsg", new Object[]{new File(".").getAbsolutePath(), this.getCurrentAppDataPath()}));
                }
            } else {
                stepConfig.setCanRestartNow(false);
            }
        }
        if (stepConfig.isAppDataNotWritable() && (!stepConfig.isNotSameDrive() || stepConfig.isAcceptNotSameDrive())) {
            if (this.isAppDataWritable()) {
                setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("appdata.writable.restartMsg", new Object[]{string2}));
                stepConfig.setCanRestartNow(true);
            } else {
                stepConfig.setCanRestartNow(false);
                string = ConfigKey.APP_DATA_PATH.getKey();
                String string3 = ConfigurationManager.getInstance().getCurrent().get(string);
                setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg("appdata.writable.errorMsg", new Object[]{string3, string2}));
            }
        }
        return setupStepProblems;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No file is read or accessed itself")
    private void a(AppDataStepConfig appDataStepConfig, SetupStepProblems setupStepProblems) {
        Path path = Paths.get(appDataStepConfig.getNewAppDataPath(), new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            FileStore fileStore;
            if (directoryStream.iterator().hasNext()) {
                setupStepProblems.addWarning(SetupWizardPlugin.MSG.getMsg("appdata.writable.dirnotempty", new Object[0]));
            }
            if ((fileStore = Files.getFileStore(path)).getUsableSpace() < 0x140000000L) {
                setupStepProblems.addWarning(SetupWizardPlugin.MSG.getMsg("appdata.writable.lowSpaceRemaining", new Object[]{fileStore.getUsableSpace() / 1024L / 1024L / 1024L}));
            }
        }
        catch (IOException iOException) {
            SetupLogger.LOGGER.error((Throwable)iOException);
            setupStepProblems.addWarning(iOException.getMessage());
        }
    }

    @Override
    public List<ServiceMethod<?, ?>> getServiceMethods() {
        List<ServiceMethod<?, ?>> list = super.getServiceMethods();
        list.add(new ServiceMethod<String, TriggerRestartResponse>(){

            public TriggerRestartResponse a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
                if (!StringFunctions.isEmpty((String)string)) {
                    SetupLogger.LOGGER.info((Object)("Apply AppData path " + string));
                    ConfigurationManager.getInstance().getCurrent().put(ConfigKey.APP_DATA_PATH, string);
                }
                CheckAppDataWritableStep.this.ar.e(true);
                if (!CheckAppDataWritableStep.this.ar.ad()) {
                    return new TriggerRestartResponse(false);
                }
                CheckAppDataWritableStep.this.ar.ae();
                return new TriggerRestartResponse(true);
            }

            public String getMethodName() {
                return "adw_triggerRestart";
            }

            public short getMethodType() {
                return 1;
            }

            public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
                return this.a(httpServletRequest, httpServletResponse, (String)object);
            }
        });
        list.add(new ServiceMethod<Void, CheckRestartedResponse>(){

            public CheckRestartedResponse a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Void void_) throws IOException {
                return new CheckRestartedResponse(CheckAppDataWritableStep.this.ar.ah());
            }

            public String getMethodName() {
                return "adw_waitForRestart";
            }

            public short getMethodType() {
                return 1;
            }

            public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
                return this.a(httpServletRequest, httpServletResponse, (Void)object);
            }
        });
        return list;
    }
}

