#!/bin/bash

# do we even have a shadow file?
[ ! -f /etc/shadow ] && "The '/etc/shadow' file does not exist." && exit 2

# first check if every user can read the shadow file
RIGHT=`stat -c "%A" /etc/shadow` && RIGHT=${RIGHT:7:1} && [ "$RIGHT" == "r" ] && echo "PAM authentication should already be possible (everyone can read the file)." && exit 0

# second check the group of the shadow file 
GROUP=$(stat -c "%G" /etc/shadow)

echo
echo "#########################################################################################################################"
echo "#"
echo "#   To allow PAM authentication against the local users of your system, our product needs read access to the"
echo "#   '/etc/shadow' file. This script will modify the '/etc/shadow' accordingly (add read access for group '$GROUP' and"
echo "#   add the DAEMON_USER (an argument you will give the script) to the group '$GROUP' of '/etc/shadow')"
echo "#"
echo "#   ATTENTION: Excuting this is script imposes a potential security risk to security hardened systems."
echo "#########################################################################################################################"
echo

DAEMON_USER=$1

# The user to add to a system group for reading shadow file

[ -z "$DAEMON_USER" ] && read -p "Username to grant access to '/etc/shadow': " DAEMON_USER
[ -z "$DAEMON_USER" ] && echo "Username was empty, will fail now. Please call the script with the user to allow access to." && exit 1

echo "Are you 100% sure that you want to grant '$DAEMON_USER' read access to '/etc/shadow' using the group '$GROUP'?"
read -p "Please type 'yes' if you are sure: " REALLY_ANSWER
if [ "$REALLY_ANSWER" != "yes" ]; then
    echo "Aborting script." && echo
    exit 3
else
    echo "Executing now." && echo
fi

# check it is even possible to use pam.d with group rights of the shadow file 
(RIGHT=`stat -c "%A" /etc/shadow` && RIGHT=${RIGHT:4:1} && [ "$RIGHT" != "r" ] &&
    chmod g+r "/etc/shadow" && [ $? -ne 0 ] && echo "The '/etc/shadow' file has no read permissions for the group '$GROUP'." ) ||
    echo "The '/etc/shadow' file has (gained) read permissions for the group '$GROUP'. This will be needed for proper PAM authentication."

# Add user to shadow group if it exists
# if the shadow does not exist or the group is root. check the /etc/group file and look for wheel
# GROUP=$( (([ "$GROUP" == "root" ] || [ -z "$GROUP" ]) && [ -f /etc/group ] && [ ! -z `grep wheel /etc/group` ] && echo "wheel") || echo "$GROUP")
GROUP=$( ([ -z "$GROUP" ] && [ -f /etc/group ] && [ ! -z `grep wheel /etc/group` ] && echo "wheel") || echo "$GROUP")

if [ ! -z "$GROUP" ]; then

    echo "Adding '$DAEMON_USER' to group: $GROUP"
    # if we did find a group (should be either 'shadow' or 'wheel') - add it to our newly created user
    if [ ! -z `which usermod` ]; then
        usermod -G "$GROUP" "$DAEMON_USER"
    elif [ ! -z `which adduser` ]; then
        adduser "$DAEMON_USER" "$GROUP"
    else
        echo "ERROR: I do not know how to add the user '$DAEMON_USER' to the priviliged group '$GROUP'. Please do this for me."
    fi
fi
