/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaData;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfig;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigAdditionalData;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepInitialConfigurationCreator;
import com.inet.shared.servlet.PortChecker;

public class WebServerStepConfigurationUpdater {
    private final WebServerStepInitialConfigurationCreator aA;
    private final ProxySetupMetaDataReader aB;
    private final PortChecker Y;

    public WebServerStepConfigurationUpdater(WebServerStepInitialConfigurationCreator initialStepConfigurationCreator, ProxySetupMetaDataReader proxyStepMetaDataReader, PortChecker portChecker) {
        if (initialStepConfigurationCreator == null) {
            throw new IllegalArgumentException("initialStepConfigurationCreator must not be null");
        }
        if (proxyStepMetaDataReader == null) {
            throw new IllegalArgumentException("proxyStepMetaDataIO must not be null");
        }
        if (portChecker == null) {
            throw new IllegalArgumentException("portChecker must not be null");
        }
        this.aA = initialStepConfigurationCreator;
        this.aB = proxyStepMetaDataReader;
        this.Y = portChecker;
    }

    public WebServerStepConfig updateConfiguration(WebServerStepConfig stepConfiguration, StepKey changedStep) {
        if (stepConfiguration == null) {
            stepConfiguration = this.aA.createInitialStepConfig();
        }
        if (changedStep == null) {
            String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.LISTENER_PORT.getKey());
            if (!this.n(string)) {
                int n = 80;
                if (this.Y.isSameAsPortThatServerIsListeningOn(80) || this.Y.isAvailable(80)) {
                    string = String.valueOf(80);
                } else {
                    ApplicationDescription applicationDescription = (ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class);
                    string = String.valueOf(applicationDescription.getDefaultPort());
                }
            }
            stepConfiguration.setPort(string);
            this.g(stepConfiguration);
        }
        return stepConfiguration;
    }

    private void g(WebServerStepConfig webServerStepConfig) {
        boolean bl;
        ProxySetupMetaData proxySetupMetaData = this.aB.read();
        if (proxySetupMetaData == null) {
            return;
        }
        String string = proxySetupMetaData.getProxyType();
        WebServerStepConfigAdditionalData webServerStepConfigAdditionalData = webServerStepConfig.additionalData();
        boolean bl2 = bl = "iis".equals(string) && !webServerStepConfigAdditionalData.isOptionMicrosoftIISEnabled();
        if (bl) {
            boolean bl3 = "https".equals(proxySetupMetaData.getProtocol());
            WebServerStepConfigAdditionalData webServerStepConfigAdditionalData2 = new WebServerStepConfigAdditionalData(webServerStepConfigAdditionalData.isProtocolSelectionEnabled() || bl3, webServerStepConfigAdditionalData.isOptionMicrosoftIISEnabled() || bl);
            webServerStepConfig.setAdditionalData(webServerStepConfigAdditionalData2);
        }
        webServerStepConfig.setOption(proxySetupMetaData.getProxyType());
        webServerStepConfig.setProtocol(proxySetupMetaData.getProtocol());
        webServerStepConfig.setContext(proxySetupMetaData.getContext());
    }

    private boolean n(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

