/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.setupwizard.basicsteps.CommandExecutor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MicrosoftIISVirtualDirExistenceChecker {
    private Path au = Paths.get(System.getenv("WINDIR") == null ? "" : System.getenv("WINDIR"), "system32", "inetsrv", "appcmd.exe");
    private CommandExecutor av = new CommandExecutor();

    public boolean isVirtualDirNameAvailable(String vdirName) throws CommandExecutor.UnsuccessfulExecutionException {
        if (vdirName == null) {
            throw new IllegalArgumentException("vdir name must not be null");
        }
        if (vdirName.trim().isEmpty()) {
            throw new IllegalArgumentException("vdir name must not be empty after trim");
        }
        boolean bl = Files.isExecutable(this.au);
        if (!bl) {
            throw new IllegalStateException("The AppCmd.exe command line could not be found");
        }
        return this.A().stream().noneMatch(string2 -> string2.equalsIgnoreCase(vdirName));
    }

    private List<String> A() throws CommandExecutor.UnsuccessfulExecutionException {
        String string3 = String.format("%s list vdir", this.au.toAbsolutePath().toString());
        String string4 = this.av.executeCommand(string3);
        String string5 = "VDIR \"Default Web Site/";
        return Arrays.asList(string4.split("\n")).stream().filter(string2 -> string2.startsWith(string5)).map(string2 -> {
            int n = (string2 = string2.substring(string5.length())).indexOf(34);
            if (n <= 0) {
                return "";
            }
            if ((string2 = string2.substring(0, n)).endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }
}

