/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.license;

import com.inet.config.ConfigKeyParser;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.core.license.LicenseEntry;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.BasicStepPriorities;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfig;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigChecker;
import com.inet.setupwizard.basicsteps.license.LicenseStepConfigUpdater;
import com.inet.setupwizard.basicsteps.license.LicenseStepExecutionTask;
import com.inet.setupwizard.basicsteps.license.LoadTrialLicenseMethod;
import com.inet.setupwizard.basicsteps.license.SystemInformationProvider;
import com.inet.setupwizard.basicsteps.license.TrialLicenseKeyProvider;
import com.inet.setupwizard.execution.chain.ExecutionChainCtrl;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LicenseStep
extends SetupStep<LicenseStepConfig> {
    public static final StepKey KEY = new StepKey("license");
    private LicenseStepConfigChecker ah;
    private TrialLicenseKeyProvider ai;
    private SystemInformationProvider aj;

    public LicenseStep(LicenseStepConfigChecker configChecker, TrialLicenseKeyProvider trialLicenseKeyProvider, SystemInformationProvider systemInformationProvider) {
        if (configChecker == null) {
            throw new IllegalArgumentException("config checker must not be null");
        }
        if (trialLicenseKeyProvider == null) {
            throw new IllegalArgumentException("trial license key provider must not be null");
        }
        this.aj = systemInformationProvider;
        this.ai = trialLicenseKeyProvider;
        this.ah = configChecker;
    }

    @Override
    public URL resourceURL(String resourceName) {
        return LicenseStep.class.getResource(resourceName);
    }

    @Override
    public StepKey stepKey() {
        return KEY;
    }

    @Override
    public boolean hasPendingTasks() {
        boolean bl;
        boolean bl2 = bl = ConfigurationManager.getInstance().getCurrent().getScope() == 4;
        if (bl) {
            return true;
        }
        return !this.ah.containsAtLeastOneValidLicenseKey();
    }

    @Override
    public LicenseStepConfig updateConfiguration(StepConfigurationStorage stepConfigurationStorage, StepsRepository repository, LicenseStepConfig data, StepKey changedStep) {
        LicenseStepConfigUpdater licenseStepConfigUpdater = new LicenseStepConfigUpdater(this.ah, this.ai, this.aj);
        return licenseStepConfigUpdater.updateConfiguration(stepConfigurationStorage, data);
    }

    @Override
    public SetupStepProblems findProblemsWithConfig(LicenseStepConfig stepConfig) {
        LicenseInfo licenseInfo = new ConfigKeyParser().getLicenseInfo(stepConfig.licenseKey()).getCurrent();
        if (licenseInfo.getAttributes().get("key") != null) {
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            ConfigStructureSettings configStructureSettings = new ConfigStructureSettings(configuration, ClientLocale.getThreadLocale(), null);
            stepConfig.setLicenseEntry(new LicenseEntry(licenseInfo, CoreSystemStructureProvider.INSTANCE, configStructureSettings, false));
        } else {
            stepConfig.setLicenseEntry(null);
        }
        return this.ah.findProblemsWithConfig(stepConfig);
    }

    @Override
    public void execute(LicenseStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        new LicenseStepExecutionTask(this.ah).execute(stepConfig);
    }

    @Override
    public SetupStepPriority getPriority() {
        return BasicStepPriorities.LICENSE;
    }

    @Override
    public InfoMessageGetter getExecutionInfoMessage(LicenseStepConfig stepConfig) {
        return () -> SetupWizardPlugin.MSG.getMsg("license.executionMessage", new Object[0]);
    }

    @Override
    public String getStepDisplayName() {
        return SetupWizardPlugin.MSG.getMsg("license.displayname", new Object[0]);
    }

    @Override
    public boolean doesRequireToRestartServerAfterExecution(LicenseStepConfig stepConfig) {
        return false;
    }

    @Override
    public List<ServiceMethod<?, ?>> getServiceMethods() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new LoadTrialLicenseMethod(this.ai));
        return arrayList;
    }

    @Override
    public Version getMigrationVersion() {
        String string = (String)((Map)ExecutionChainCtrl.LAST_MIGRATED_PLUGIN_VERSIONS.get()).get(ServerPluginManager.getInstance().getCorePluginId());
        if (string == null) {
            return null;
        }
        return ServerPluginManager.getInstance().getPluginDescription(ServerPluginManager.getInstance().getCorePluginId()).getVersion();
    }
}

