/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.defaultwebserver.uninstaller;

import com.inet.lib.util.FileHelper;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaData;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import com.inet.setupwizard.basicsteps.webserver.uninstaller.ProxySettingsAndResourcesRemover;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;

public class DefaultProxySettingsAndResourcesRemover {
    public void removeProxySettingsAndResourcesIfNeeded(Path installationDir, ProxySetupMetaDataReader metaDataIO) {
        if (installationDir == null) {
            throw new IllegalArgumentException("installationDir must not be null");
        }
        if (metaDataIO == null) {
            throw new IllegalArgumentException("metaDataIO must not be null");
        }
        ProxySetupMetaData proxySetupMetaData = metaDataIO.read();
        if (proxySetupMetaData != null) {
            ProxySettingsAndResourcesRemover proxySettingsAndResourcesRemover = new ProxySettingsAndResourcesRemover(metaDataIO);
            ProxySettingsAndResourcesRemover.MicrosoftIISProxyResourcesRemovalTask microsoftIISProxyResourcesRemovalTask = () -> {
                final Path path2 = installationDir.resolve("IIS");
                ArrayList<Path> arrayList = new ArrayList<Path>(){
                    {
                        this.add(path2.resolve("index.htm"));
                        this.add(path2.resolve("web.config"));
                        this.add(path2.resolve("ClientProxy.vb"));
                        this.add(path2.resolve("default.aspx"));
                    }
                };
                for (Path path3 : arrayList) {
                    try {
                        FileHelper.deleteFileIfExists((Path)path3);
                    }
                    catch (IOException iOException) {
                        SetupLogger.LOGGER.warn((Object)iOException);
                    }
                }
                try {
                    if (Files.exists(path2, new LinkOption[0]) && DefaultProxySettingsAndResourcesRemover.a(path2)) {
                        FileHelper.deleteFileIfExists((Path)path2);
                    }
                }
                catch (IOException iOException) {
                    SetupLogger.LOGGER.warn((Object)iOException);
                }
            };
            proxySettingsAndResourcesRemover.removeProxySettingsAndResourcesIfNeeded(microsoftIISProxyResourcesRemovalTask);
        } else {
            SetupLogger.LOGGER.warn((Object)"Proxy setup meta data is missing or could not be read.");
        }
    }

    private static boolean a(Path path) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }
}

