/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.defaultwebserver.newinstallation;

import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.defaultwebserver.DefaultMicrosoftIISExecutionTask;
import com.inet.setupwizard.basicsteps.defaultwebserver.newinstallation.ServerURLConfigValueSetter;
import com.inet.setupwizard.basicsteps.webserver.ListenerPortSetter;
import com.inet.setupwizard.basicsteps.webserver.MicrosoftIISVirtualDirExistenceChecker;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaData;
import com.inet.setupwizard.basicsteps.webserver.ProxySetupMetaDataReader;
import com.inet.setupwizard.basicsteps.webserver.StandaloneExecutionTask;
import com.inet.setupwizard.basicsteps.webserver.WebServerStep;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfig;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigChecker;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfigurationUpdater;
import com.inet.shared.servlet.PortChecker;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class DefaultWebServerStep
extends WebServerStep<WebServerStepConfig> {
    private final PortChecker Y;
    private final WebServerStepConfigChecker Z;
    private final WebServerStepConfigurationUpdater aa;
    private final Path V;
    private final ProxySetupMetaDataReader ab;
    private ThreadLocal<Boolean> ac = new ThreadLocal<Boolean>(){

        protected Boolean p() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.p();
        }
    };

    public DefaultWebServerStep(Path installationDir, PortChecker portChecker, WebServerStepConfigurationUpdater stepConfigurationUpdater, ProxySetupMetaDataReader metaDataIO) {
        if (installationDir == null) {
            throw new IllegalArgumentException("installationDir must not be null");
        }
        if (portChecker == null) {
            throw new IllegalArgumentException("port checker must not be null");
        }
        if (stepConfigurationUpdater == null) {
            throw new IllegalArgumentException("stepConfigurationUpdater must not be null");
        }
        this.V = installationDir;
        this.Y = portChecker;
        this.Z = new WebServerStepConfigChecker(portChecker, new MicrosoftIISVirtualDirExistenceChecker());
        this.aa = stepConfigurationUpdater;
        this.ab = metaDataIO;
    }

    @Override
    public boolean hasPendingTasks() {
        return this.ab.read() == null;
    }

    @Override
    public SetupStepProblems findProblemsWithConfig(WebServerStepConfig stepConfig) {
        return this.Z.findProblemsWithConfig(stepConfig);
    }

    @Override
    public WebServerStepConfig updateConfiguration(StepConfigurationStorage storage, StepsRepository repository, WebServerStepConfig stepConfig, StepKey changedStep) {
        WebServerStepConfig webServerStepConfig = this.aa.updateConfiguration(stepConfig, changedStep);
        return webServerStepConfig;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    public void execute(WebServerStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        SetupStepProblems setupStepProblems = this.Z.findProblemsWithConfig(stepConfig);
        if (setupStepProblems.hasErrors()) {
            throw new IllegalStateException("stepConfig must be valid at this point, error messages: " + String.valueOf(setupStepProblems.getErrors()));
        }
        ApplicationDescription applicationDescription = (ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class);
        String string = applicationDescription.getVersion().toString();
        switch (stepConfig.option()) {
            case "iis": {
                SetupLogger.LOGGER.info((Object)String.format("[Proxy] Install IIS proxy with context %s", stepConfig.context()));
                this.executeIIS(stepConfig);
                this.a(stepConfig, string);
                break;
            }
            case "standalone": {
                SetupLogger.LOGGER.info((Object)"[Proxy] Set Up as Standalone");
                int n = Integer.parseInt(stepConfig.port());
                String string2 = Persistence.isFilePersistence() ? ((FilePersistence)Persistence.getInstance()).getPersistenceFolder().resolve(".ssh").toString() : "";
                Path path = Paths.get(string2, "sslCertificate.crt");
                Path path2 = Paths.get(string2, "privateKey.key");
                new StandaloneExecutionTask(this.Y).execute(n, path, path2);
                this.h(string);
            }
        }
        if (!CoreSystemStructureProvider.isDocker() || !System.getProperty("setupautoexecution", "false").equalsIgnoreCase("true")) {
            this.a(stepConfig);
        }
    }

    protected void executeIIS(WebServerStepConfig stepConfig) throws StepExecutionException {
        DefaultMicrosoftIISExecutionTask defaultMicrosoftIISExecutionTask = new DefaultMicrosoftIISExecutionTask(this.V, new ListenerPortSetter());
        defaultMicrosoftIISExecutionTask.executeNewInstallation(stepConfig.context(), stepConfig.protocol());
    }

    private void a(WebServerStepConfig webServerStepConfig, String string) throws StepExecutionException {
        this.a(new ProxySetupMetaData(webServerStepConfig.option(), webServerStepConfig.context(), webServerStepConfig.protocol(), string));
    }

    private void h(String string) throws StepExecutionException {
        this.a(new ProxySetupMetaData("standalone", "", "http", string));
    }

    private void a(ProxySetupMetaData proxySetupMetaData) throws StepExecutionException {
        try {
            this.ab.save(proxySetupMetaData);
        }
        catch (IOException iOException) {
            throw new StepExecutionException("Could not create file containing proxy meta data.", iOException);
        }
    }

    @Override
    public boolean doesRequireToRestartServerAfterExecution(WebServerStepConfig stepConfig) {
        if (stepConfig != null && stepConfig.option().equals("standalone")) {
            int n = Integer.parseInt(stepConfig.port());
            return new StandaloneExecutionTask(this.Y).willRestartServer(n);
        }
        return false;
    }

    private void a(WebServerStepConfig webServerStepConfig) {
        int n;
        ServerURLConfigValueSetter serverURLConfigValueSetter = new ServerURLConfigValueSetter();
        if (webServerStepConfig.getServerUrl() != null && !webServerStepConfig.getServerUrl().trim().isEmpty()) {
            serverURLConfigValueSetter.setServerURLInCurrentConfiguration(webServerStepConfig.getServerUrl());
            return;
        }
        boolean bl = "https".equals(webServerStepConfig.protocol());
        Object object = webServerStepConfig.context();
        switch (webServerStepConfig.option()) {
            case "standalone": {
                bl = false;
                object = "";
                n = Integer.parseInt(webServerStepConfig.port());
                break;
            }
            case "iis": {
                n = 80;
                object = (String)object + "/default.aspx";
                break;
            }
            default: {
                throw new IllegalStateException("cannot come here");
            }
        }
        serverURLConfigValueSetter.setServerURLInCurrentConfiguration(bl, webServerStepConfig.getServerHostName(), n, (String)object);
    }
}

