/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.api;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepKey;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

@JsonData
public class StepConfigurationStorage {
    private List<StepConfigurationStorageEntry> configs = new ArrayList<StepConfigurationStorageEntry>();

    public void add(StepKey stepKey, StepConfiguration stepConfiguration) {
        if (stepKey == null) {
            throw new IllegalArgumentException("step key must not be null");
        }
        if (stepConfiguration == null) {
            throw new IllegalArgumentException("step configuration must not be null");
        }
        if (this.contains(stepKey)) {
            throw new IllegalArgumentException("storage already contains step with key \"" + stepKey.toString() + "\"");
        }
        this.configs.add(new StepConfigurationStorageEntry(stepKey, stepConfiguration));
    }

    private boolean contains(StepKey stepKey) {
        return this.configs.stream().anyMatch(entry -> stepKey.equals(entry.stepKey()));
    }

    public int size() {
        return this.configs.size();
    }

    public boolean isEmpty() {
        return this.configs.size() == 0;
    }

    public List<StepConfigurationStorageEntry> entries() {
        return new ArrayList<StepConfigurationStorageEntry>(this.configs);
    }

    public List<StepConfigurationStorageEntry> entriesAfter(StepKey key) {
        if (key == null) {
            throw new IllegalArgumentException("key must be not null");
        }
        for (int i = 0; i < this.configs.size(); ++i) {
            StepConfigurationStorageEntry stepConfigurationStorageEntry = this.configs.get(i);
            if (!stepConfigurationStorageEntry.stepKey().equals(key)) continue;
            return this.configs.subList(i + 1, this.configs.size());
        }
        throw new IllegalArgumentException("storage does not contain configuration for key: " + key.toString());
    }

    public StepConfigurationStorageEntry get(StepKey stepKey) {
        if (stepKey == null) {
            throw new IllegalArgumentException("step key must not be null");
        }
        try {
            return this.configs.stream().filter(entry -> stepKey.equals(entry.stepKey())).findFirst().get();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @JsonData
    public static class StepConfigurationStorageEntry {
        private String stepKey;
        private String jsonData;
        private SetupStepProblems problems = new SetupStepProblems();
        private String executionInfoMessage;

        private StepConfigurationStorageEntry(StepKey stepKey, StepConfiguration stepConfig) {
            this.stepKey = stepKey.toString();
            this.setStepConfiguration(stepConfig);
        }

        private StepConfigurationStorageEntry() {
        }

        public StepKey stepKey() {
            return new StepKey(this.stepKey);
        }

        public <T extends StepConfiguration> T stepConfiguration(Type clazz) {
            return (T)((StepConfiguration)new Json().fromJson(this.jsonData, clazz));
        }

        public void setStepConfiguration(StepConfiguration stepConfig) {
            this.jsonData = new Json().toJson((Object)stepConfig);
        }

        public SetupStepProblems getProblems() {
            return this.problems;
        }

        public void setProblems(SetupStepProblems errors) {
            this.problems = errors;
        }

        public String getExecutionInfoMessage() {
            return this.executionInfoMessage;
        }

        public void setExecutionInfoMessage(InfoMessageGetter executionInfoMessage) {
            this.executionInfoMessage = executionInfoMessage == null ? null : executionInfoMessage.getMsg();
        }
    }
}

