/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.webserver;

import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.SetupStepProblems;
import com.inet.setupwizard.basicsteps.CommandExecutor;
import com.inet.setupwizard.basicsteps.webserver.MicrosoftIISVirtualDirExistenceChecker;
import com.inet.setupwizard.basicsteps.webserver.WebServerStepConfig;
import com.inet.shared.servlet.PortChecker;

public class WebServerStepConfigChecker {
    private PortChecker Y;
    private MicrosoftIISVirtualDirExistenceChecker az;

    public WebServerStepConfigChecker(PortChecker portChecker, MicrosoftIISVirtualDirExistenceChecker vdirChecker) {
        if (portChecker == null) {
            throw new IllegalArgumentException("port checker must not be null");
        }
        if (vdirChecker == null) {
            throw new IllegalArgumentException("vdir checker must not be null");
        }
        this.Y = portChecker;
        this.az = vdirChecker;
    }

    public SetupStepProblems findProblemsWithConfig(WebServerStepConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("step config must not be null");
        }
        SetupStepProblems setupStepProblems = new SetupStepProblems();
        this.d(setupStepProblems, config);
        this.c(setupStepProblems, config);
        this.b(setupStepProblems, config);
        this.a(setupStepProblems, config);
        return setupStepProblems;
    }

    private void a(SetupStepProblems setupStepProblems, WebServerStepConfig webServerStepConfig) {
        if (this.e(webServerStepConfig)) {
            if (!this.Y.isValidPort(webServerStepConfig.port())) {
                this.a(setupStepProblems, "webserver.portIsInvalid", new Object[0]);
                return;
            }
            int n = Integer.parseInt(webServerStepConfig.port());
            if (this.Y.isSameAsPortThatServerIsListeningOn(n)) {
                return;
            }
            if (!this.Y.isAvailable(n)) {
                this.a(setupStepProblems, "webserver.portIsNotAvailable", webServerStepConfig.port());
            }
        }
    }

    private void b(SetupStepProblems setupStepProblems, WebServerStepConfig webServerStepConfig) {
        if (this.f(webServerStepConfig)) {
            if (this.c(webServerStepConfig) || this.d(webServerStepConfig)) {
                return;
            }
            this.a(setupStepProblems, "webserver.protocolIsInvalid", new Object[0]);
        }
    }

    private void c(SetupStepProblems setupStepProblems, WebServerStepConfig webServerStepConfig) {
        if (this.f(webServerStepConfig)) {
            int n;
            String string = webServerStepConfig.context();
            if (string == null || string.isEmpty()) {
                this.a(setupStepProblems, "webserver.contextIsMissing", new Object[0]);
                return;
            }
            int n2 = string.length();
            if (n2 != (n = string.replaceAll("[^\\-_0-9a-zA-Z]", "").length())) {
                this.a(setupStepProblems, "webserver.contextIsInvalid", new Object[0]);
                return;
            }
            try {
                if (this.az.isVirtualDirNameAvailable(webServerStepConfig.context())) {
                    return;
                }
                this.a(setupStepProblems, "webserver.contextAlreadyExists", new Object[0]);
            }
            catch (CommandExecutor.UnsuccessfulExecutionException unsuccessfulExecutionException) {
                // empty catch block
            }
        }
    }

    private void d(SetupStepProblems setupStepProblems, WebServerStepConfig webServerStepConfig) {
        if (this.f(webServerStepConfig) || this.e(webServerStepConfig)) {
            return;
        }
        this.a(setupStepProblems, "webserver.optionIsInvalid", new Object[0]);
    }

    private boolean c(WebServerStepConfig webServerStepConfig) {
        return "http".equals(webServerStepConfig.protocol());
    }

    private boolean d(WebServerStepConfig webServerStepConfig) {
        return "https".equals(webServerStepConfig.protocol());
    }

    private boolean e(WebServerStepConfig webServerStepConfig) {
        return "standalone".equals(webServerStepConfig.option());
    }

    private boolean f(WebServerStepConfig webServerStepConfig) {
        return "iis".equals(webServerStepConfig.option());
    }

    private void a(SetupStepProblems setupStepProblems, String string, Object ... objectArray) {
        setupStepProblems.addError(SetupWizardPlugin.MSG.getMsg(string, objectArray));
    }
}

