/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.permissions;

import com.inet.config.ConfigurationManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.setupwizard.SetupWizardPlugin;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.BasicStepPriorities;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserManagerAdminPermissionMigrationStep
extends SetupStep<EmptyStepConfig> {
    public static final StepKey KEY = new StepKey("UserManagerAdminPermissionMigrationStep");
    private static Permission ap;

    public UserManagerAdminPermissionMigrationStep() {
        if (ServerPluginManager.getInstance().isPluginLoaded("webapi.core")) {
            Object object;
            String string = ConfigurationManager.getInstance().getCurrent().get("setupExecutedSteps");
            boolean bl = false;
            if (string != null && !string.isEmpty()) {
                object = (HashSet)new Json().fromJson(string, HashSet.class);
                bl = ((HashSet)object).contains(this.stepKey().toString());
            }
            if ((object = this.getLastMigratedVersionOfThisPlugin()) != null && (this.getMigrationVersion() == null || this.getMigrationVersion().isHigherThan((Version)object)) && !bl) {
                ap = SystemPermissionManager.add((String)"webapi.core.readUserManager", (String)"administration", (String)"webapi.core", (int)7791, (boolean)false, this.getClass());
            }
        }
    }

    @Override
    public StepKey stepKey() {
        return KEY;
    }

    @Override
    public String getStepDisplayName() {
        return SetupWizardPlugin.MSG.getMsg("userManagerAdminStep.message", new Object[0]);
    }

    @Override
    public boolean hasPendingTasks() {
        return true;
    }

    @Override
    public Version getMigrationVersion() {
        PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("usersandgroups/userbackupfrombefore254restored");
        if (persistenceEntry.exists()) {
            return null;
        }
        return new Version("25.4.47");
    }

    @Override
    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        GUID gUID3;
        GUID gUID22;
        UserManagerWait.waitForUserManagerVeto(this.getStepExecutionProgressListener(), this);
        Set<Permission> set = Set.of(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        orSearchExpression.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER.getKey()));
        orSearchExpression.add((Object)new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Administrator.name()));
        Set set2 = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{orSearchExpression}));
        SetupLogger.LOGGER.info((Object)String.format("Update usermanager admin permission for %d users", set2.size()));
        for (GUID gUID22 : set2) {
            UserManager.getInstance().updateUserPermissions(gUID22, set, Set.of());
        }
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        gUID22 = new SearchCommand("permissions", SearchCondition.SearchTermOperator.Equals, (Object)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER.getKey());
        Object object = userGroupManager.getSearchEngine().simpleSearch((SearchCommand)gUID22).iterator();
        while (object.hasNext()) {
            gUID3 = (GUID)object.next();
            if (gUID3.equals((Object)UsersAndGroups.GROUPID_ADMIN)) continue;
            SetupLogger.LOGGER.info((Object)String.format("Update usermanager admin permission for group %s", gUID3.toString()));
            userGroupManager.updateGroupPermissions(gUID3, set, Set.of());
        }
        if (ap != null) {
            set2 = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)ap.getKey())}));
            set = Set.of(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
            for (GUID gUID3 : set2) {
                SetupLogger.LOGGER.info((Object)String.format("[webapi] Update user permission for user %s", gUID3.toString()));
                UserManager.getInstance().updateUserPermissions(gUID3, set, Set.of());
            }
            gUID22 = new SearchCommand("permissions", SearchCondition.SearchTermOperator.Equals, (Object)ap.getKey());
            object = userGroupManager.getSearchEngine().simpleSearch((SearchCommand)gUID22).iterator();
            while (object.hasNext()) {
                gUID3 = (GUID)object.next();
                if (gUID3.equals((Object)UsersAndGroups.GROUPID_ADMIN)) continue;
                SetupLogger.LOGGER.info((Object)String.format("[webapi] Update usermanager permission for group %s", gUID3.toString()));
                userGroupManager.updateGroupPermissions(gUID3, set, Set.of());
            }
        }
        if ((object = Persistence.getInstance().resolve("usersandgroups/userbackupfrombefore254restored")).exists()) {
            object.deleteTree();
        }
    }

    @Override
    public SetupStepPriority getPriority() {
        return BasicStepPriorities.SYSTEMPERMISSIONS;
    }

    @Override
    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> "";
    }

    @Override
    public boolean doesRequireToRestartServerAfterExecution(EmptyStepConfig stepConfig) {
        return true;
    }

    @Override
    public EmptyStepConfig updateConfiguration(StepConfigurationStorage storage, StepsRepository repository, EmptyStepConfig stepConfig, StepKey changedStep) {
        return new EmptyStepConfig();
    }
}

