/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setupwizard.basicsteps.license;

import com.inet.annotations.JsonData;
import com.inet.config.structure.core.license.LicenseEntry;
import com.inet.setupwizard.api.StepConfiguration;
import java.util.Map;
import java.util.Objects;

@JsonData
public class LicenseStepConfig
extends StepConfiguration {
    private String licenseKey = "";
    private boolean isIncludedInConfiguration;
    private LicenseEntry licenseEntry;
    private String trialLicenseUrl;
    private boolean isTrialLicense;
    private Map<String, String> systemInformations;

    public LicenseStepConfig() {
    }

    public LicenseStepConfig(String licenseKey, boolean isIncludedInConfiguration, boolean isTrialLicense, Map<String, String> systemInformations) {
        this.licenseKey = licenseKey;
        this.isIncludedInConfiguration = isIncludedInConfiguration;
        this.isTrialLicense = isTrialLicense;
        this.systemInformations = systemInformations;
    }

    public LicenseStepConfig(String trialLicenseUrl, Map<String, String> systemInformations) {
        this.trialLicenseUrl = trialLicenseUrl;
        this.systemInformations = systemInformations;
    }

    public String licenseKey() {
        return this.licenseKey;
    }

    public boolean isIncludedInConfiguration() {
        return this.isIncludedInConfiguration;
    }

    public String getTrialLicenseUrl() {
        return this.trialLicenseUrl;
    }

    public boolean isTrialLicense() {
        return this.isTrialLicense;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.isTrialLicense ? 1231 : 1237);
        n2 = 31 * n2 + (this.isIncludedInConfiguration ? 1231 : 1237);
        n2 = 31 * n2 + (this.licenseKey == null ? 0 : this.licenseKey.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LicenseStepConfig licenseStepConfig = (LicenseStepConfig)obj;
        if (this.isIncludedInConfiguration != licenseStepConfig.isIncludedInConfiguration) {
            return false;
        }
        if (this.isTrialLicense != licenseStepConfig.isTrialLicense) {
            return false;
        }
        return Objects.equals(this.licenseKey, licenseStepConfig.licenseKey);
    }

    public LicenseEntry getLicenseEntry() {
        return this.licenseEntry;
    }

    public void setLicenseEntry(LicenseEntry licenseEntry) {
        this.licenseEntry = licenseEntry;
    }

    public void setTrialLicenseUrl(String trialLicenseUrl) {
        this.trialLicenseUrl = trialLicenseUrl;
    }

    public Map<String, String> getSystemInformations() {
        return this.systemInformations;
    }

    public void setSystemInformations(Map<String, String> systemInformations) {
        this.systemInformations = systemInformations;
    }
}

