# Application Server

## Requirements

To use i-net Clear Reports in an application server, it is necessary that the application server:

  * uses at least Java EE 11 (Java 17)
  * supports Servlet Specifications 6.1 including WebSocket 2.2

## Before you deploy

Before you deploy i-net Clear Reports for the first time you need to think about the authentication method you would like to use. If i-net Clear Reports was already deployed, it is difficult to change the authentication settings (see Password Recovery below). 

By default, i-net Clear Reports uses the operating system/domain accounts for authentication. On Windows it uses `Windows Authentication` and on Linux/Unix/MacOS it uses `PAM authentication` based on /etc/pam.d/reporting or /etc/pam.d/login.

PAM on Linux or Mac:

  * PAM needs access to the `/etc/shadow` file in order to allow authentication for local users of the server. For that you must give the user your application server is running with read-access to the `/etc/shadow` file (we recommend to add the user to the shadow group if you have such a group on your system).

Alternatives are:

  * Use **Guest Account** for login. This is already enabled by default. Then it will be possible to use the link "Login as Guest" in the start page of the report server. With activated `guest account` authentication provider, it is possible to access the remote GUI of i-net Clear Reports without authentication. In the Permissions dialog of the Configuration manager, it is possible to restrict the access for the guest account.
  * Login with the internal mechanism of the **Application Server Authentication**. For this purpose it is necessary to set the `authentication.settings=[{"provider":"internal"}]` in the file `initial_configuration.properties` and activate the plugin `Script Authentication`. In the web.xml some further adjustments for authentication must be done.
  * Authentication through an **External Web Server**. For this purpose it is necessary to provide a login script. See the [Security Settings](http://docs.inetsoftware.de/reporting/help/security) in the configuration about details.
  * Use a "Master Password" to login. To use it copy one of the files in folder `password-recovery` as remotelogin.xml into the working directory of your application server. This is typically the installation directory or bin directory of the application server, for example: `/var/lib/tomcat8` on Ubuntu.

## Deployment

To deploy i-net Clear Reports you need to copy the file `reporting.war` from the `clear-reports-war-<version>.zip` or the modified version (see above chapter) to your Application Server. For more information about WAR file deployment, please refer to the documentation of your application server.

see also the FAQ: [Installing in Tomcat with Java 17+](https://faq.inetsoftware.de/t/tomcat-with-java-17/281)

## Password Recovery

If you already deployed i-net Clear Reports into your application server, any changes to the `initial_configuration.properties` will not have any effect. In this case, use the following steps to open the configuration if you can not login:

  * In the folder `password-recovery` you can find some well-known passwords. Choose a file and rename it to remotelogin.xml. If these passwords are too unsafe for temporary use, you can create a safe password file with the recovery tool of the i-net Clear Reports SDK.
  * Copy the file remotelogin.xml into the working directory of your application server. This is typically the installation directory or bin directory of the application server, for example: `/var/lib/tomcat8` on Ubuntu.
  * Restart the application server.
  * Call the URL http(s)://<host:port>/reporting/login/master.
  * Enter the chosen password.
  * In the Configuration Manager dialog `Login` change your authentication setting and test it. Logout and login again.
  * If you choose Master Login for future use then change it to a secure password. The password's salted hash is stored in two places - the file remotelogin.xml and the Configuration (stored in the Java Preferences).
  * Delete any insecure remotelogin.xml files that you have copied before.
  * Restart the application server.

## Recovery Tool

If you have problems to access your i-net Clear Reports configuration web interface (e.g. if you are missing required permissions) you can use the Recovery Tool to repair your configuration. To do this, download and install the i-net Clear Reports SDK and start the Recovery Tool (startRecovery.sh/.bat) locally on your server. After that you should restart the application server. 

 It will not reset the i-net Clear Reports configuration if you just undeploy/deploy the `reporting.war` again!

## Specific Modifications

### WebLogic Server

By default WebLogic requires authentication for any secure HTTP-page. As a result users must authenticate against the webserver in addition to the Login-type set in the i-net Clear Reports configuration. If you face the problem that you have to provide an additional login to the login you have configured, do the following:

Open the configuration-file of your WebLogic-Domain

(by default *<WebLogicServerHome>*/user_projects/domains*/<Your domainname>*/config/config.xml)

Add the following as the last item below the node *<security-configuration>*:

```bash
<enforce-valid-basic-auth-credentials>false</enforce-valid-basic-auth-credentials>
```

You must restart your server for the changes to take effect.

### WebSphere Server

##### Add MIME-Type 'png'

IBM WebSphere Applicationserver does not support MIME-Type 'png' by default. Therefore it is necessary to add the MIME-Type 'png' to your application server. Follow the instructions [here](http://publib.boulder.ibm.com/infocenter/mpadoc/v7r0m0/index.jsp?topic=%2Fcom.ibm.websphere.wemp.doc%2Fconfiguring%2Fconfiguringwastoacceptmimetypes.html) or see the appropriate help page for your IBM WebSphere application server version.

