package com.inet.samples.factory;

import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.cache.Cache;

/**
 * Server plugin which sets a custom EngineFactory.
 */
@PluginInfo( //
id = "enginefactory",// 
dependencies = "reporting", //
group = "samples", //
version = "25.10.314", //
icon = "com/inet/samples/factory/enginefactory_48.png" //
)
public class EngineFactoryPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        Cache.setEngineFactory( new CustomEngineFactory() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
