/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel.parser;

import com.inet.excel.parser.SheetDimension;

public class RowSpanData {
    private int firstColumnIndex = 0;
    private int lastColumnIndex = 0;

    public void addSpanRange(String spans) {
        int spanEnd;
        int spanStart;
        if (spans == null) {
            return;
        }
        try {
            String[] range = spans.split(":");
            spanStart = Integer.parseInt(range[0]);
            spanEnd = Integer.parseInt(range[1]);
        }
        catch (Exception ex) {
            return;
        }
        this.updateIndexes(spanStart, spanEnd);
    }

    public void addCellRef(String ref) {
        if (ref == null) {
            return;
        }
        int columnIndex = SheetDimension.getColumnIndexFromCellRef(ref);
        this.updateIndexes(columnIndex, columnIndex);
    }

    private void updateIndexes(int spanStart, int spanEnd) {
        if (spanStart < 1 || spanEnd < 1 || spanStart > spanEnd) {
            return;
        }
        if (this.firstColumnIndex < 1 || spanStart < this.firstColumnIndex) {
            this.firstColumnIndex = spanStart;
        }
        if (spanEnd > this.lastColumnIndex) {
            this.lastColumnIndex = spanEnd;
        }
    }

    public boolean isEmpty() {
        return this.firstColumnIndex < 1 || this.lastColumnIndex < 1;
    }

    public int getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    public int getLastColumnIndex() {
        return this.lastColumnIndex;
    }
}

