/*
 * Decompiled with CFR 0.152.
 */
package jbarcodebean;

import java.io.Serializable;
import jbarcodebean.AbstractBarcodeStrategy;
import jbarcodebean.BaseCode39;

public class ExtendedCode39
extends BaseCode39
implements Serializable {
    private static Conversion[] conversions = new Conversion[]{new Conversion('\u0000', "%U"), new Conversion('\u0001', "$A"), new Conversion('\u0002', "$B"), new Conversion('\u0003', "$C"), new Conversion('\u0004', "$D"), new Conversion('\u0005', "$E"), new Conversion('\u0006', "$F"), new Conversion('\u0007', "$G"), new Conversion('\b', "$H"), new Conversion('\t', "$I"), new Conversion('\n', "$J"), new Conversion('\u000b', "$K"), new Conversion('\f', "$L"), new Conversion('\r', "$M"), new Conversion('\u000e', "$N"), new Conversion('\u000f', "$O"), new Conversion('\u0010', "$P"), new Conversion('\u0011', "$Q"), new Conversion('\u0012', "$R"), new Conversion('\u0013', "$S"), new Conversion('\u0014', "$T"), new Conversion('\u0015', "$U"), new Conversion('\u0016', "$V"), new Conversion('\u0017', "$W"), new Conversion('\u0018', "$X"), new Conversion('\u0019', "$Y"), new Conversion('\u001a', "$Z"), new Conversion('\u001b', "%A"), new Conversion('\u001c', "%B"), new Conversion('\u001d', "%C"), new Conversion('\u001e', "%D"), new Conversion('\u001f', "%E"), new Conversion('!', "/A"), new Conversion('\"', "/B"), new Conversion('#', "/C"), new Conversion('$', "/D"), new Conversion('%', "/E"), new Conversion('&', "/F"), new Conversion('\'', "/G"), new Conversion('(', "/H"), new Conversion(')', "/I"), new Conversion('*', "/J"), new Conversion('+', "/K"), new Conversion(',', "/L"), new Conversion('-', "/M"), new Conversion('.', "/N"), new Conversion('/', "/O"), new Conversion(':', "/Z"), new Conversion(';', "%F"), new Conversion('<', "%G"), new Conversion('=', "%H"), new Conversion('>', "%I"), new Conversion('?', "%J"), new Conversion('@', "%V"), new Conversion('[', "%K"), new Conversion('\\', "%L"), new Conversion(']', "%M"), new Conversion('^', "%N"), new Conversion('_', "%O"), new Conversion('`', "%W"), new Conversion('a', "+A"), new Conversion('b', "+B"), new Conversion('c', "+C"), new Conversion('d', "+D"), new Conversion('e', "+E"), new Conversion('f', "+F"), new Conversion('g', "+G"), new Conversion('h', "+H"), new Conversion('i', "+I"), new Conversion('j', "+J"), new Conversion('k', "+K"), new Conversion('l', "+L"), new Conversion('m', "+M"), new Conversion('n', "+N"), new Conversion('o', "+O"), new Conversion('p', "+P"), new Conversion('q', "+Q"), new Conversion('r', "+R"), new Conversion('s', "+S"), new Conversion('t', "+T"), new Conversion('u', "+U"), new Conversion('v', "+V"), new Conversion('w', "+W"), new Conversion('x', "+X"), new Conversion('y', "+Y"), new Conversion('z', "+Z"), new Conversion('{', "%P"), new Conversion('|', "%Q"), new Conversion('}', "%R"), new Conversion('~', "%S"), new Conversion('\u007f', "%T")};

    protected AbstractBarcodeStrategy.CharacterCode[] getCodes() {
        return BaseCode39.codes;
    }

    protected String preprocess(String string) {
        String string2 = "";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = 0; j < conversions.length; ++j) {
                if (c != ExtendedCode39.conversions[j].from) continue;
                string2 = string2 + ExtendedCode39.conversions[j].to;
                bl = true;
                break;
            }
            if (bl) continue;
            string2 = string2 + c;
        }
        return string2;
    }

    protected String getBarcodeLabelText(String string) {
        return string;
    }

    private static class Conversion {
        char from;
        String to;

        public Conversion(char c, String string) {
            this.from = c;
            this.to = string;
        }
    }
}

