/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.BytesByReference;
import com.inet.odbc.OdbcConnection;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcPreparedStatement;
import com.inet.odbc.OdbcUtils;
import com.sun.jna.NativeLong;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.NativeLongByReference;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;

class OdbcParam {
    static final short UNKNOWN_TYPE = 9999;
    private final OdbcPreparedStatement st;
    private Object value;
    private int odbcType = 9999;
    private Object bindBuffer;
    private NativeLongByReference bindSize;

    OdbcParam(OdbcPreparedStatement st) {
        this.st = st;
    }

    void setValue(Object value, int jdbcType) {
        this.value = value;
        this.odbcType = OdbcUtils.getOdbcType(jdbcType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(int parameterIndex) throws SQLException {
        OdbcConnection con = this.st.getConnection();
        Object object = con.getLock();
        synchronized (object) {
            if (this.value == null) {
                switch (this.odbcType) {
                    case 9999: {
                        throw new SQLException("Empty Parameter: " + parameterIndex, "07001");
                    }
                }
                short scale = 0;
                this.bindSize = new NativeLongByReference(new NativeLong(-1L));
                this.st.checkSqlReturn(OdbcLibrary.ODBC.SQLBindParameter(this.st.getHStmt(), (short)parameterIndex, (short)1, (short)1, (short)this.odbcType, new NativeLong(1L), scale, (ByReference)null, null, this.bindSize));
                this.bindBuffer = null;
            } else {
                short cDataType;
                short scale;
                byte[] bytes;
                switch (this.odbcType) {
                    case 93: {
                        OdbcLibrary.TimestampStructure dataTS = new OdbcLibrary.TimestampStructure((Timestamp)this.value);
                        this.bindBuffer = dataTS;
                        NativeLong precision = new NativeLong(23L);
                        this.st.checkSqlReturn(OdbcLibrary.ODBC.SQLBindParameter(this.st.getHStmt(), (short)parameterIndex, (short)1, (short)11, (short)this.odbcType, precision, (short)3, dataTS, null, null));
                        return;
                    }
                    case 2: {
                        BigDecimal decimal = (BigDecimal)this.value;
                        bytes = con.toAnsiBytes(decimal.toString());
                        scale = (short)decimal.scale();
                        cDataType = 1;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        bytes = (byte[])this.value;
                        scale = 0;
                        cDataType = -2;
                        break;
                    }
                    default: {
                        bytes = con.toBytes(this.value.toString());
                        scale = 0;
                        cDataType = OdbcLibrary.UNICODE ? (short)-8 : 1;
                    }
                }
                BytesByReference data = new BytesByReference(bytes.length + 1);
                data.setValue(bytes);
                this.bindBuffer = data;
                NativeLong size = new NativeLong((long)bytes.length);
                NativeLong precision = size.intValue() == 0 ? new NativeLong(1L) : size;
                this.bindSize = new NativeLongByReference(size);
                this.st.checkSqlReturn(OdbcLibrary.ODBC.SQLBindParameter(this.st.getHStmt(), (short)parameterIndex, (short)1, cDataType, (short)this.odbcType, precision, scale, data, size, this.bindSize));
            }
        }
    }
}

