/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.BytesByReference;
import com.inet.odbc.ColumnDescription;
import com.inet.odbc.OdbcConnection;
import com.inet.odbc.OdbcInputStream;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcResultSetMetaData;
import com.inet.odbc.OdbcStatement;
import com.sun.jna.Memory;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

abstract class AbstractOdbcResultSet
implements ResultSet {
    private final OdbcConnection con;
    private final OdbcStatement stmt;
    private final OdbcResultSetMetaData metaData;
    private int[] columnsHashKeys;
    private SQLWarning warnings;
    private boolean isClosed;
    private boolean wasNull;
    private ByteByReference byteRef;
    private IntByReference intRef;
    private LongByReference longRef;
    private FloatByReference floatRef;
    private DoubleByReference doubleRef;

    AbstractOdbcResultSet(OdbcStatement stmt, int columnCount) {
        this.con = stmt.getConnection();
        this.stmt = stmt;
        this.metaData = new OdbcResultSetMetaData(columnCount, stmt);
    }

    void checkSqlReturn(short ret) throws SQLException {
        this.warnings = null;
        this.warnings = this.con.checkSqlReturn(ret, this.getStatement().getHStmt());
    }

    void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed");
        }
    }

    Object getData(ColumnDescription column) throws SQLException {
        Object object = this.con.getLock();
        synchronized (object) {
            byte[] bytes;
            short getDataType;
            BytesByReference value;
            short columnType = column.getOdbcType();
            switch (columnType) {
                case -7: 
                case 16: {
                    if (this.byteRef == null) {
                        this.byteRef = new ByteByReference();
                    }
                    value = this.byteRef;
                    getDataType = -7;
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    if (this.intRef == null) {
                        this.intRef = new IntByReference();
                    }
                    value = this.intRef;
                    getDataType = 4;
                    break;
                }
                case -5: {
                    if (this.longRef == null) {
                        this.longRef = new LongByReference();
                    }
                    value = this.longRef;
                    getDataType = -25;
                    break;
                }
                case 7: {
                    if (this.floatRef == null) {
                        this.floatRef = new FloatByReference();
                    }
                    value = this.floatRef;
                    getDataType = 7;
                    break;
                }
                case 6: 
                case 8: {
                    if (this.doubleRef == null) {
                        this.doubleRef = new DoubleByReference();
                    }
                    value = this.doubleRef;
                    getDataType = 8;
                    break;
                }
                case 2: 
                case 3: {
                    value = this.con.getBytesMaxSqlLengthRef();
                    getDataType = 1;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    value = this.con.getBytesMaxSqlLengthRef();
                    getDataType = -2;
                    break;
                }
                case -1: {
                    value = this.con.getBytesMaxSqlLengthRef();
                    getDataType = 1;
                    break;
                }
                case -16: {
                    value = this.con.getBytesMaxSqlLengthRef();
                    getDataType = -8;
                    break;
                }
                default: {
                    int colLength = Math.max(512, column.getColumnLength() * 2 + 2);
                    value = new BytesByReference(colLength);
                    getDataType = OdbcLibrary.UNICODE ? (short)-8 : 1;
                }
            }
            int size = (int)((Memory)value.getPointer()).size();
            IntByReference length = this.con.getIntRef();
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLGetData(this.getStatement().getHStmt(), column.getIndex(), getDataType, value, size, length));
            int count = length.getValue();
            switch (count) {
                case -1: {
                    this.wasNull = true;
                    return null;
                }
                case -4: {
                    this.wasNull = false;
                    throw new SQLException("Data conversion error SQL_NO_TOTAL on column " + column.getName());
                }
            }
            this.wasNull = false;
            switch (getDataType) {
                case 4: {
                    return ((IntByReference)value).getValue();
                }
                case -25: {
                    return ((LongByReference)value).getValue();
                }
                case 7: {
                    return Float.valueOf(((FloatByReference)value).getValue());
                }
                case 8: {
                    return ((DoubleByReference)value).getValue();
                }
                case -7: {
                    return ((ByteByReference)value).getValue() != 0;
                }
            }
            if (count >= size) {
                int nullTerminateSize;
                bytes = new byte[count];
                switch (getDataType) {
                    case -2: {
                        nullTerminateSize = 0;
                        break;
                    }
                    default: {
                        nullTerminateSize = 1;
                        break;
                    }
                    case -8: {
                        nullTerminateSize = 2;
                    }
                }
                int firstSize = size - nullTerminateSize;
                value.getValue(bytes, firstSize);
                int nextSize = count - firstSize + nullTerminateSize;
                BytesByReference lastValue = new BytesByReference(nextSize);
                this.checkSqlReturn(OdbcLibrary.ODBC.SQLGetData(this.getStatement().getHStmt(), column.getIndex(), getDataType, lastValue, nextSize, length));
                lastValue.getValue(bytes, firstSize, nextSize - nullTerminateSize);
            } else {
                bytes = value.getValue(count);
            }
            if (getDataType == -2) {
                return bytes;
            }
            String str = getDataType == 1 ? this.con.toAnsiString(bytes, bytes.length) : this.con.toString(bytes, bytes.length);
            try {
                switch (columnType) {
                    case 2: 
                    case 3: {
                        return new BigDecimal(str);
                    }
                    case 9: 
                    case 11: {
                        if (str.length() == 10) {
                            str = str + " 00:00:00";
                        }
                        return Timestamp.valueOf(str);
                    }
                    case 92: {
                        return Time.valueOf(str);
                    }
                    case 91: {
                        return Date.valueOf(str);
                    }
                    case 93: {
                        return Timestamp.valueOf(str);
                    }
                }
                return str;
            }
            catch (RuntimeException ex) {
                throw new SQLException("Can't convert value: " + str + " of column: " + column.getName() + " width type: " + columnType, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getData(ColumnDescription column, byte[] buffer) throws SQLException {
        Object object = this.con.getLock();
        synchronized (object) {
            IntByReference length = this.con.getIntRef();
            BytesByReference value = new BytesByReference(buffer.length);
            short ret = OdbcLibrary.ODBC.SQLGetData(this.getStatement().getHStmt(), column.getIndex(), (short)-2, value, buffer.length, length);
            if (ret == 100) {
                return 0;
            }
            this.checkSqlReturn(ret);
            int count = length.getValue();
            if (count == -1) {
                return 0;
            }
            value.getValue(buffer, Math.min(buffer.length, count));
            return count;
        }
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        this.warnings = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed || this.getStatement().isClosed();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            long value = this.getLong(columnIndex);
            return value != 0L;
        }
        catch (NumberFormatException e) {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof String && ((String)obj).length() > 0) {
                return ((String)obj).toLowerCase().charAt(0) == 't';
            }
            throw new SQLException(e);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        long value = this.getLong(columnIndex);
        if (value > 127L) {
            return 127;
        }
        if (value < -128L) {
            return -128;
        }
        return (byte)value;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        long value = this.getLong(columnIndex);
        if (value > 32767L) {
            return Short.MAX_VALUE;
        }
        if (value < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)value;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        long value = this.getLong(columnIndex);
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0L;
        }
        try {
            return ((Number)obj).longValue();
        }
        catch (Exception e) {
            return Long.parseLong(obj.toString());
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return (float)this.getDouble(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        try {
            return ((Number)obj).doubleValue();
        }
        catch (Exception e) {
            return Double.parseDouble(obj.toString());
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal decimal = this.getBigDecimal(columnIndex);
        if (decimal == null) {
            return null;
        }
        return decimal.setScale(scale, 6);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        try {
            return (byte[])obj;
        }
        catch (Exception e) {
            return this.getStatement().getConnection().toBytes(obj.toString());
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        try {
            return (Date)obj;
        }
        catch (Exception e) {
            if (obj instanceof java.util.Date) {
                return new Date(((java.util.Date)obj).getYear(), ((java.util.Date)obj).getMonth(), ((java.util.Date)obj).getDate());
            }
            try {
                return Date.valueOf(obj.toString().trim());
            }
            catch (Exception e2) {
                throw new SQLException("Can't convert '" + obj + "' to Date.", "S1000");
            }
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        try {
            return (Time)obj;
        }
        catch (Exception e) {
            if (obj instanceof java.util.Date) {
                return new Time(((java.util.Date)obj).getHours(), ((java.util.Date)obj).getMinutes(), ((java.util.Date)obj).getSeconds());
            }
            try {
                return Time.valueOf(obj.toString().trim());
            }
            catch (Exception e2) {
                throw new SQLException("Can't convert '" + obj + "' to Time.", "S1000");
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        try {
            return (Timestamp)obj;
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(obj.toString().trim());
            }
            catch (Exception e2) {
                throw new SQLException("Can't convert '" + obj + "' to Timestamp.", "S1000");
            }
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ColumnDescription column = this.metaData.getColumn(columnIndex);
        this.wasNull = false;
        return new OdbcInputStream(this, column, 2);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        ColumnDescription column = this.metaData.getColumn(columnIndex);
        this.wasNull = false;
        return new OdbcInputStream(this, column, 4);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        ColumnDescription column = this.metaData.getColumn(columnIndex);
        this.wasNull = false;
        return new OdbcInputStream(this, column, 1);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public OdbcResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int[] searchTree = this.columnsHashKeys;
        if (searchTree == null) {
            searchTree = this.columnsHashKeys = this.generateColumnsSearchTree();
        }
        int colSize = columnLabel.length();
        int idx = 0;
        block0: for (int j = 0; j < colSize; ++j) {
            int c = columnLabel.charAt(j) | 0x20;
            while (searchTree[idx] != -1) {
                if (searchTree[idx] == c) {
                    int searchResult;
                    if (j == colSize - 1 && (searchResult = searchTree[idx + 2]) != 0) {
                        return searchResult;
                    }
                    if ((idx = searchTree[idx + 1]) != 0) continue block0;
                    break block0;
                }
                idx += 3;
            }
            break block0;
        }
        if (colSize == 0) {
            int colCount = this.metaData.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                if (this.metaData.getColumnLabel(i).length() != 0) continue;
                return i + 1;
            }
        }
        throw new SQLException("Column '" + columnLabel + "' not found.", "S0022");
    }

    private int[] generateColumnsSearchTree() throws SQLException {
        int colCount = this.metaData.getColumnCount();
        int treeSize = 1;
        for (int i = colCount; i > 0; --i) {
            treeSize += this.metaData.getColumnLabel(i).length();
        }
        int[] searchTree = new int[treeSize * 6];
        searchTree[0] = -1;
        treeSize = 3;
        for (int i = colCount; i > 0; --i) {
            String col = this.metaData.getColumnLabel(i);
            int colSize = col.length();
            int idx = 0;
            block2: for (int j = 0; j < colSize; ++j) {
                int c = col.charAt(j) | 0x20;
                while (searchTree[idx] != -1) {
                    if (searchTree[idx] == c) {
                        if (j == colSize - 1) {
                            searchTree[idx + 2] = i;
                            continue block2;
                        }
                        int newIdx = searchTree[idx + 1];
                        if (newIdx == 0) {
                            int n = treeSize;
                            searchTree[idx + 1] = n;
                            newIdx = n;
                            searchTree[treeSize] = -1;
                            treeSize += 3;
                        }
                        idx = newIdx;
                        continue block2;
                    }
                    idx += 3;
                }
                System.arraycopy(searchTree, idx, searchTree, idx + 3, treeSize - idx);
                treeSize += 3;
                for (int n = 1; n < treeSize; n += 3) {
                    if (searchTree[n] <= idx) continue;
                    int n2 = n;
                    searchTree[n2] = searchTree[n2] + 3;
                }
                searchTree[idx] = c;
                if (j == colSize - 1) {
                    searchTree[idx + 2] = i;
                    continue;
                }
                searchTree[idx + 1] = treeSize;
                ++j;
                while (j < colSize) {
                    searchTree[treeSize] = col.charAt(j) | 0x20;
                    if (j == colSize - 1) {
                        searchTree[treeSize + 2] = i;
                    } else {
                        searchTree[treeSize + 1] = treeSize + 6;
                    }
                    searchTree[treeSize += 3] = -1;
                    treeSize += 3;
                    ++j;
                }
            }
        }
        return searchTree;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        try {
            return (BigDecimal)obj;
        }
        catch (Exception e) {
            try {
                return new BigDecimal(obj.toString().trim());
            }
            catch (Exception e2) {
                throw new SQLException("Can't convert '" + obj + "' to BigDecimal.", "S1000");
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    private void forwardOnly() throws SQLException {
        throw new SQLException("Illegal method's call for result set of type TYPE_FORWARD_ONLY.", "01000");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.forwardOnly();
    }

    @Override
    public void afterLast() throws SQLException {
        this.forwardOnly();
    }

    @Override
    public boolean first() throws SQLException {
        this.forwardOnly();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.forwardOnly();
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.forwardOnly();
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.forwardOnly();
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.forwardOnly();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    private void readonly() throws SQLException {
        throw new SQLException("ResultSet is read only.", "24000");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.readonly();
    }

    @Override
    public void updateRow() throws SQLException {
        this.readonly();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.readonly();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.forwardOnly();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.readonly();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.readonly();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.readonly();
    }

    @Override
    public OdbcStatement getStatement() {
        return this.stmt;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnLabel), x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        this.updateNString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), x);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.readonly();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        this.readonly();
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), x);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        int valueType = this.getMetaData().getColumnType(columnIndex);
        switch (valueType) {
            case 12: {
                if (type != String.class) break;
                return (T)this.getString(columnIndex);
            }
        }
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(this.getClass().getName() + " does not implements " + iface.getName() + ".", "01000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

