/*
 * Decompiled with CFR 0.152.
 */
package com.inet.beans.pdf417;

import com.inet.beans.pdf417.Pdf417lib;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.swing.JComponent;

public class Pdf417
extends JComponent {
    private int lastWidth;
    private int lastHeigth;
    private Image image;
    private boolean changed;
    private boolean autoScale = true;
    private Pdf417lib pd = new Pdf417lib();

    public Pdf417() {
        this.pd.setOptions(128);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        if (this.changed || w != this.lastWidth || h != this.lastHeigth) {
            this.changed = false;
            this.lastWidth = w;
            this.lastHeigth = h;
            this.image = this.createBarcode2DImage(w, h);
        }
        g.drawImage(this.image, 0, 0, this);
    }

    public int getCodeRows() {
        return this.pd.getCodeRows();
    }

    public void setCodeRows(int codeRows) {
        if (this.pd.getCodeRows() != codeRows) {
            this.pd.setCodeRows(codeRows);
            this.notifyChanged();
        }
    }

    public int getCodeColumns() {
        return this.pd.getCodeColumns();
    }

    public void setCodeColumns(int codeColumns) {
        if (this.pd.getCodeColumns() != codeColumns) {
            this.pd.setCodeColumns(codeColumns);
            this.notifyChanged();
        }
    }

    public int getLengthCodewords() {
        return this.pd.getLenCodewords();
    }

    public void setLengthCodewords(int lengthCodewords) {
        if (this.pd.getLenCodewords() != lengthCodewords) {
            this.pd.setLenCodewords(lengthCodewords);
            this.notifyChanged();
        }
    }

    public int getErrorLevel() {
        return this.pd.getErrorLevel();
    }

    public void setErrorLevel(int errorLevel) {
        if (this.pd.getErrorLevel() != errorLevel) {
            this.pd.setErrorLevel(errorLevel);
            this.notifyChanged();
        }
    }

    public String getText() throws UnsupportedEncodingException {
        return new String(this.pd.getText(), "Cp437");
    }

    public void setText(String s) throws UnsupportedEncodingException {
        byte[] oldText = this.pd.getText();
        this.pd.setText(s);
        if (!Arrays.equals(oldText, this.pd.getText())) {
            this.notifyChanged();
        }
    }

    public float getAspectRatio() {
        return this.pd.getAspectRatio();
    }

    public void setAspectRatio(float aspectRatio) {
        if (this.pd.getAspectRatio() != aspectRatio) {
            this.pd.setAspectRatio(aspectRatio);
            this.notifyChanged();
        }
    }

    public float getYHeight() {
        return this.pd.getYHeight();
    }

    public void setYHeight(float yHeight) {
        if (this.pd.getYHeight() != yHeight) {
            this.pd.setYHeight(yHeight);
            this.notifyChanged();
        }
    }

    public void setFixedRectangle(boolean b) {
        this.setOptions(1, b);
    }

    public boolean isFixedRectangle() {
        return (this.pd.getOptions() & 1) != 0;
    }

    public void setFixedColumns(boolean b) {
        this.setOptions(2, b);
    }

    public boolean isFixedColumns() {
        return (this.pd.getOptions() & 2) != 0;
    }

    public void setFixedRows(boolean b) {
        this.setOptions(4, b);
    }

    public boolean isFixedRows() {
        return (this.pd.getOptions() & 4) != 0;
    }

    public void setAutoErrorLevel(boolean b) {
        this.setOptions(16, !b);
    }

    public boolean isAutoErrorLevel() {
        return (this.pd.getOptions() & 0x10) == 0;
    }

    protected void setOptions(int options, boolean b) {
        int op = this.pd.getOptions();
        this.pd.setOptions(b ? op | options : op & ~options);
        if (this.pd.getOptions() != op) {
            this.notifyChanged();
        }
    }

    public void setAutoScale(boolean b) {
        if (this.autoScale != b) {
            this.autoScale = b;
            this.notifyChanged();
        }
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void notifyChanged() {
        this.changed = true;
    }

    public Pdf417lib getPdf417Lib() {
        return this.pd;
    }

    protected Image createBarcode2DImage(int width, int height) {
        this.pd.paintCode();
        final byte[] ar = this.pd.getOutBits();
        boolean f = true;
        final BufferedImage bi = new BufferedImage(1 * this.pd.getBitColumns(), 1 * this.pd.getCodeRows(), 1);
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                int bit;
                int w = (bi.getWidth() / 1 - 1) / 8 + 1;
                int index = (y /= 1) * w + (x /= 1) / 8;
                int pos = x % 8;
                if (index < ar.length && (bit = Pdf417.getBit(ar[index], pos)) == 0) {
                    return Color.BLACK.getRGB();
                }
                return Color.WHITE.getRGB();
            }
        };
        FilteredImageSource filteredSrc = new FilteredImageSource(bi.getSource(), filter);
        Image im = Toolkit.getDefaultToolkit().createImage(filteredSrc);
        if (this.autoScale) {
            im = im.getScaledInstance(width, height, 4);
        }
        return im;
    }

    private static int getBit(byte b, int index) {
        return b >>> 7 - index & 1;
    }
}

