/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.elements.support.attributes.FontFamily;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.CharConverter;

public final class StringUtil {
    private static final int LOWERCASE_START = 97;
    private static final int UPPERCASE_START = 65;
    private static final int NUM_CHARS = 26;
    private static final Map<Integer, CodePointAndVariant> HIGHPLANE_MAPPING = new HashMap<Integer, CodePointAndVariant>();
    private static final Map<Integer, Integer> FRAKTUR_MAPPING = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> SCRIPT_MAPPING = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> DOUBLE_MAPPING = new HashMap<Integer, Integer>();

    private StringUtil() {
    }

    public static AttributedString convertStringtoAttributedString(String inputString, MathVariant baseVariant, float fontSize, MathBase base) {
        StringBuilder builder = new StringBuilder();
        Vector<MathVariant> variants = new Vector<MathVariant>();
        String plainString = CharConverter.convertLate(inputString);
        for (int i = 0; i < plainString.length(); ++i) {
            if (Character.isLowSurrogate(plainString.charAt(i))) continue;
            CodePointAndVariant cpav = new CodePointAndVariant(plainString.codePointAt(i), baseVariant);
            cpav = StringUtil.mapHighCodepointToLowerCodepoints(cpav);
            cpav = StringUtil.mapVariantsToStandardCodepoints(cpav);
            int codePoint = cpav.getCodePoint();
            MathVariant variant = cpav.getVariant();
            builder.appendCodePoint(codePoint);
            variants.add(variant);
            if (!Character.isSupplementaryCodePoint(codePoint)) continue;
            variants.add(variant);
        }
        AttributedString aString = new AttributedString(builder.toString());
        for (int i = 0; i < builder.length(); ++i) {
            MathVariant variant = (MathVariant)variants.get(i);
            aString.addAttribute(TextAttribute.FONT, variant.createFont(fontSize, builder.charAt(i), base), i, i + 1);
        }
        return aString;
    }

    public static TextLayout createTextLayoutFromAttributedString(Graphics2D g, AttributedString aString, MathBase mathBase) {
        AttributedCharacterIterator charIter = aString.getIterator();
        boolean empty = charIter.first() == '\uffff';
        FontRenderContext suggestedFontRenderContext = g.getFontRenderContext();
        boolean antialiasing = Boolean.parseBoolean(mathBase.getParams().get((Object)ParameterKey.AntiAlias));
        FontRenderContext realFontRenderContext = new FontRenderContext(suggestedFontRenderContext.getTransform(), antialiasing, false);
        TextLayout theLayout = !empty ? new TextLayout(aString.getIterator(), realFontRenderContext) : new TextLayout(" ", new Font("", 0, 0), realFontRenderContext);
        return theLayout;
    }

    private static CodePointAndVariant mapVariantsToStandardCodepoints(CodePointAndVariant cpav) {
        Integer mapping;
        int codePoint = cpav.getCodePoint();
        MathVariant variant = cpav.getVariant();
        int awtStyle = variant.getAwtStyle();
        FontFamily fontFamily = variant.getFontFamily();
        if (FontFamily.FRAKTUR.equals((Object)fontFamily)) {
            Integer mapping2 = FRAKTUR_MAPPING.get(codePoint);
            if (mapping2 != null) {
                codePoint = mapping2;
                variant = new MathVariant(awtStyle, FontFamily.SANSSERIF);
            }
        } else if (FontFamily.SCRIPT.equals((Object)fontFamily)) {
            Integer mapping3 = SCRIPT_MAPPING.get(codePoint);
            if (mapping3 != null) {
                codePoint = mapping3;
                variant = new MathVariant(awtStyle, FontFamily.SANSSERIF);
            }
        } else if (FontFamily.DOUBLE_STRUCK.equals((Object)fontFamily) && (mapping = DOUBLE_MAPPING.get(codePoint)) != null) {
            codePoint = mapping;
            variant = new MathVariant(awtStyle, FontFamily.SANSSERIF);
        }
        return new CodePointAndVariant(codePoint, variant);
    }

    private static CodePointAndVariant mapHighCodepointToLowerCodepoints(CodePointAndVariant cpav) {
        int codePoint = cpav.getCodePoint();
        CodePointAndVariant mappedTo = HIGHPLANE_MAPPING.get(codePoint);
        if (mappedTo != null) {
            return mappedTo;
        }
        return cpav;
    }

    public static float getWidthForTextLayout(TextLayout layout) {
        Rectangle2D r2d = layout.getBounds();
        float realWidth = (float)r2d.getWidth();
        float xo = (float)r2d.getX();
        if (xo > 0.0f) {
            realWidth += xo;
        }
        float invisibleAdvance = layout.getAdvance() - layout.getVisibleAdvance();
        return realWidth + invisibleAdvance;
    }

    private static void addHighMapping(int codePointStart, MathVariant mapToVariant) {
        int i;
        for (i = 0; i < 26; ++i) {
            HIGHPLANE_MAPPING.put(codePointStart + i, new CodePointAndVariant(65 + i, mapToVariant));
        }
        for (i = 0; i < 26; ++i) {
            HIGHPLANE_MAPPING.put(codePointStart + 26 + i, new CodePointAndVariant(97 + i, mapToVariant));
        }
    }

    private static void initializeVariantToStandardMapping() {
        FRAKTUR_MAPPING.put(67, 8493);
        FRAKTUR_MAPPING.put(72, 8460);
        FRAKTUR_MAPPING.put(73, 8465);
        FRAKTUR_MAPPING.put(82, 8476);
        FRAKTUR_MAPPING.put(90, 8488);
        SCRIPT_MAPPING.put(66, 8492);
        SCRIPT_MAPPING.put(69, 8496);
        SCRIPT_MAPPING.put(101, 8495);
        SCRIPT_MAPPING.put(70, 8497);
        SCRIPT_MAPPING.put(103, 8458);
        SCRIPT_MAPPING.put(72, 8459);
        SCRIPT_MAPPING.put(73, 8464);
        SCRIPT_MAPPING.put(76, 8466);
        SCRIPT_MAPPING.put(77, 8499);
        SCRIPT_MAPPING.put(111, 8500);
        SCRIPT_MAPPING.put(82, 8475);
        DOUBLE_MAPPING.put(67, 8450);
        DOUBLE_MAPPING.put(72, 8461);
        DOUBLE_MAPPING.put(78, 8469);
        DOUBLE_MAPPING.put(80, 8473);
        DOUBLE_MAPPING.put(81, 8474);
        DOUBLE_MAPPING.put(82, 8477);
        DOUBLE_MAPPING.put(90, 8484);
    }

    private static void initializeHighPlaneMappings() {
        StringUtil.addHighMapping(119808, MathVariant.BOLD);
        StringUtil.addHighMapping(119860, MathVariant.ITALIC);
        StringUtil.addHighMapping(119912, MathVariant.BOLD_ITALIC);
        StringUtil.addHighMapping(119964, MathVariant.SCRIPT);
        StringUtil.addHighMapping(120016, MathVariant.BOLD_SCRIPT);
        StringUtil.addHighMapping(120068, MathVariant.FRAKTUR);
        StringUtil.addHighMapping(120120, MathVariant.DOUBLE_STRUCK);
        StringUtil.addHighMapping(120172, MathVariant.BOLD_FRAKTUR);
        StringUtil.addHighMapping(120224, MathVariant.SANS_SERIF);
        StringUtil.addHighMapping(120276, MathVariant.BOLD_SANS_SERIF);
        StringUtil.addHighMapping(120328, MathVariant.SANS_SERIF_ITALIC);
        StringUtil.addHighMapping(120380, MathVariant.SANS_SERIF_BOLD_ITALIC);
        StringUtil.addHighMapping(120432, MathVariant.MONOSPACE);
    }

    static {
        StringUtil.initializeVariantToStandardMapping();
        StringUtil.initializeHighPlaneMappings();
    }

    private static class CodePointAndVariant {
        private final int codePoint;
        private final MathVariant variant;

        protected CodePointAndVariant(int icodePoint, MathVariant ivariant) {
            this.codePoint = icodePoint;
            this.variant = ivariant;
        }

        public final int getCodePoint() {
            return this.codePoint;
        }

        public final MathVariant getVariant() {
            return this.variant;
        }
    }
}

