/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

public final class CharConverter {
    private static final String[][] LATE_MAP = new String[][]{{"\u2061", ""}, {"\u200b", ""}, {"\u2062", ""}, {"\u2148", "i"}, {"\u0332", "\u00af"}};
    private static final String[][] EARLY_MAP = new String[][]{{"\ue080", "\u2031"}, {"\ue081", "\uf613"}, {"\ue083", "+"}, {"\ue084", "<"}, {"\ue085", ">"}, {"\ue086", "\ue425"}, {"\ue087", "\ue421"}, {"\ue089", "\u2208"}, {"\ue08a", "\u0192"}, {"\ue08b", "\u2026"}, {"\ue08c", "\u2192"}, {"\ue091", "\u0302"}, {"\ue092", "\u030c"}, {"\ue093", "\u0306"}, {"\ue094", "\u0301"}, {"\ue095", "\u0300"}, {"\ue096", "\u0303"}, {"\ue097", "\u0304"}, {"\ue098", "\u2192"}, {"\ue099", "\u02d9"}, {"\ue09a", "\u0308"}, {"\ue09b", "\u20db"}, {"\ue09c", "\u030a"}, {"\ue09e", "("}, {"\ue09f", ")"}, {"\ue0a2", "\u301a"}, {"\ue0a3", "\u301b"}, {"\ue0a4", "\u2373"}, {"\ue0a8", "/"}, {"\ue0a9", "\\"}, {"\ue0aa", "\u274f"}, {"\ue0ac", "\u0393"}, {"\ue0ad", "\u0394"}, {"\ue0ae", "\u0398"}, {"\ue0af", "\u039b"}, {"\ue0b0", "\u039e"}, {"\ue0b1", "\u03a0"}, {"\ue0b2", "\u03a3"}, {"\ue0b3", "\u03a5"}, {"\ue0b4", "\u03a6"}, {"\ue0b5", "\u03a8"}, {"\ue0b6", "\u03a9"}, {"\ue0b7", "\u03b1"}, {"\ue0b8", "\u03b2"}, {"\ue0b9", "\u03b3"}, {"\ue0ba", "\u03b4"}, {"\ue0bb", "\u03b5"}, {"\ue0bc", "\u03b6"}, {"\ue0bd", "\u03b7"}, {"\ue0be", "\u03b8"}, {"\ue0bf", "\u03b9"}, {"\ue0c0", "\u03ba"}, {"\ue0c1", "\u03bb"}, {"\ue0c2", "\u03bc"}, {"\ue0c3", "\u03bd"}, {"\ue0c4", "\u03be"}, {"\ue0c5", "\u03bf"}, {"\ue0c6", "\u03c0"}, {"\ue0c7", "\u03c1"}, {"\ue0c8", "\u03c3"}, {"\ue0c9", "\u03c4"}, {"\ue0ca", "\u03c5"}, {"\ue0cb", "\u03c6"}, {"\ue0cc", "\u03c7"}, {"\ue0cd", "\u03c8"}, {"\ue0ce", "\u03c9"}, {"\ue0cf", "\u03b5"}, {"\ue0d0", "\u03d1"}, {"\ue0d1", "\u03d6"}, {"\ue0d2", "\u03f1"}, {"\ue0d3", "\u03db"}, {"\ue0d4", "\u2118"}, {"\ue0d5", "\u2202"}, {"\ue0d6", "\u2129"}, {"\ue0d7", "\u2107"}, {"\ue0d8", "\u2127"}, {"\ue0d9", "\u22a4"}, {"\ue0da", "\u019b"}, {"\ue0db", "\u2190"}, {"\ue0dc", "\u2191"}, {"\ue0dd", "\u2193"}};

    private CharConverter() {
    }

    private static String actualConvert(String string, String[][] map) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            boolean touched = false;
            for (int j = 0; j < map.length; ++j) {
                if (!string.regionMatches(i, map[j][0], 0, map[j][0].length())) continue;
                buffer.append(map[j][1]);
                touched = true;
                i += map[j][0].length() - 1;
            }
            if (touched) continue;
            buffer.append(string.charAt(i));
        }
        return buffer.toString();
    }

    public static String convertEarly(String string) {
        return CharConverter.actualConvert(string, EARLY_MAP);
    }

    public static String convertLate(String string) {
        return CharConverter.actualConvert(string, LATE_MAP);
    }
}

