/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementListSupport {
    private ElementListSupport() {
    }

    public static List<JEuclidElement> createListOfChildren(Node parent) {
        NodeList childList = parent.getChildNodes();
        int len = childList.getLength();
        ArrayList<JEuclidElement> children = new ArrayList<JEuclidElement>(len);
        for (int i = 0; i < len; ++i) {
            Node child = childList.item(i);
            if (!(child instanceof JEuclidElement)) continue;
            children.add((JEuclidElement)child);
        }
        return children;
    }

    public static float getAscentHeight(Graphics2D g, List<JEuclidElement> elements) {
        float height = 0.0f;
        for (JEuclidElement element : elements) {
            height = Math.max(height, element.getAscentHeight(g));
        }
        return height;
    }

    public static float getDescentHeight(Graphics2D g, List<JEuclidElement> elements) {
        float height = 0.0f;
        for (JEuclidElement element : elements) {
            height = Math.max(height, element.getDescentHeight(g));
        }
        return height;
    }

    public static float getHeight(Graphics2D g, List<JEuclidElement> elements) {
        return ElementListSupport.getAscentHeight(g, elements) + ElementListSupport.getDescentHeight(g, elements);
    }

    public static float getWidth(Graphics2D g, List<JEuclidElement> elements) {
        float width = 0.0f;
        for (JEuclidElement element : elements) {
            width += element.getWidth(g);
        }
        return width;
    }

    public static void paint(Graphics2D g, float posX, float posY, List<JEuclidElement> elements) {
        float pos = posX;
        for (JEuclidElement element : elements) {
            element.paint(g, pos, posY);
            pos += element.getWidth(g);
        }
    }

    public static void fireChangeForSubTree(List<JEuclidElement> elements) {
        for (JEuclidElement element : elements) {
            element.fireChangeForSubTree();
        }
    }
}

