/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import java.awt.Graphics2D;
import java.util.List;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.script.AbstractScriptElement;
import net.sourceforge.jeuclid.elements.presentation.script.Mprescripts;
import net.sourceforge.jeuclid.elements.presentation.script.None;
import net.sourceforge.jeuclid.elements.presentation.script.ScriptSupport;
import net.sourceforge.jeuclid.elements.support.MathMLNodeListImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLMultiScriptsElement;
import org.w3c.dom.mathml.MathMLNodeList;

public class Mmultiscripts
extends AbstractScriptElement
implements MathMLMultiScriptsElement {
    public static final String ELEMENT = "mmultiscripts";
    private static final int STATE_POSTSUB = 0;
    private static final int STATE_POSTSUPER = 1;
    private static final int STATE_PRESUB = 2;
    private static final int STATE_PRESUPER = 3;
    private final List<JEuclidElement> postsubscripts = new Vector<JEuclidElement>();
    private final List<JEuclidElement> postsuperscripts = new Vector<JEuclidElement>();
    private final List<JEuclidElement> presubscripts = new Vector<JEuclidElement>();
    private final List<JEuclidElement> presuperscripts = new Vector<JEuclidElement>();
    private boolean inRewriteChildren = false;
    private Graphics2D lastCalculatedFor = null;
    private float subBaselineShift;
    private float superBaselineShift;
    private float ascentHeight;
    private float descentHeight;
    private float width;

    public Mmultiscripts(MathBase base) {
        super(base);
    }

    protected void changeHook() {
        super.changeHook();
        if (!this.inRewriteChildren) {
            this.parseChildren();
        }
        this.lastCalculatedFor = null;
    }

    private void parseChildren() {
        this.presubscripts.clear();
        this.presuperscripts.clear();
        this.postsubscripts.clear();
        this.postsuperscripts.clear();
        NodeList childList = this.getChildNodes();
        int state = 0;
        int len = childList.getLength();
        for (int i = 1; i < len; ++i) {
            Node child = childList.item(i);
            if (child instanceof Mprescripts) {
                state = 2;
                continue;
            }
            if (!(child instanceof JEuclidElement)) continue;
            JEuclidElement jchild = (JEuclidElement)child;
            if (state == 0) {
                this.postsubscripts.add(jchild);
                state = 1;
                continue;
            }
            if (state == 1) {
                this.postsuperscripts.add(jchild);
                state = 0;
                continue;
            }
            if (state == 2) {
                this.presubscripts.add(jchild);
                state = 3;
                continue;
            }
            this.presuperscripts.add(jchild);
            state = 2;
        }
        if (this.postsuperscripts.size() < this.postsubscripts.size()) {
            this.postsuperscripts.add(new None(this.getMathBase()));
        }
        if (this.presuperscripts.size() < this.presubscripts.size()) {
            this.presuperscripts.add(new None(this.getMathBase()));
        }
    }

    private void calculateSpecs(Graphics2D g) {
        float esupbaselineshift;
        float esubbaselineshift;
        JEuclidElement sup;
        JEuclidElement sub;
        int i;
        if (g == this.lastCalculatedFor) {
            return;
        }
        this.lastCalculatedFor = g;
        JEuclidElement base = this.getBase();
        this.subBaselineShift = 0.0f;
        this.superBaselineShift = 0.0f;
        float maxSupAscent = 0.0f;
        float maxSubDescent = 0.0f;
        this.width = base.getWidth(g);
        for (i = 0; i < this.postsubscripts.size(); ++i) {
            sub = this.postsubscripts.get(i);
            sup = this.postsuperscripts.get(i);
            esubbaselineshift = ScriptSupport.getSubBaselineShift(g, base, sub, sup);
            esupbaselineshift = ScriptSupport.getSuperBaselineShift(g, base, sub, sup);
            this.subBaselineShift = Math.max(this.subBaselineShift, esubbaselineshift);
            this.superBaselineShift = Math.max(this.superBaselineShift, esupbaselineshift);
            maxSupAscent = Math.max(maxSupAscent, sup.getAscentHeight(g));
            maxSubDescent = Math.max(maxSubDescent, sub.getDescentHeight(g));
            this.width += Math.max(sub.getWidth(g), sup.getWidth(g));
        }
        for (i = 0; i < this.presubscripts.size(); ++i) {
            sub = this.presubscripts.get(i);
            sup = this.presuperscripts.get(i);
            esubbaselineshift = ScriptSupport.getSubBaselineShift(g, base, sub, sup);
            esupbaselineshift = ScriptSupport.getSuperBaselineShift(g, base, sub, sup);
            this.subBaselineShift = Math.max(this.subBaselineShift, esubbaselineshift);
            this.superBaselineShift = Math.max(this.superBaselineShift, esupbaselineshift);
            maxSupAscent = Math.max(maxSupAscent, sup.getAscentHeight(g));
            maxSubDescent = Math.max(maxSubDescent, sub.getDescentHeight(g));
            this.width += Math.max(sub.getWidth(g), sup.getWidth(g));
        }
        this.ascentHeight = Math.max(base.getAscentHeight(g), this.superBaselineShift + maxSupAscent);
        this.descentHeight = Math.max(base.getDescentHeight(g), this.subBaselineShift + maxSubDescent);
    }

    public final void paint(Graphics2D g, float posX, float posY) {
        JEuclidElement sup;
        JEuclidElement sub;
        int i;
        super.paint(g, posX, posY);
        this.calculateSpecs(g);
        JEuclidElement base = this.getBase();
        float pos = posX;
        for (i = 0; i < this.presubscripts.size(); ++i) {
            sub = this.presubscripts.get(i);
            sup = this.presuperscripts.get(i);
            sub.paint(g, pos, posY + this.subBaselineShift);
            sup.paint(g, pos, posY - this.superBaselineShift);
            pos += Math.max(sub.getWidth(g), sup.getWidth(g));
        }
        base.paint(g, pos, posY);
        pos += base.getWidth(g);
        for (i = 0; i < this.postsubscripts.size(); ++i) {
            sub = this.postsubscripts.get(i);
            sup = this.postsuperscripts.get(i);
            sub.paint(g, pos, posY + this.subBaselineShift);
            sup.paint(g, pos, posY - this.superBaselineShift);
            pos += Math.max(sub.getWidth(g), sup.getWidth(g));
        }
    }

    public final float calculateWidth(Graphics2D g) {
        this.calculateSpecs(g);
        return this.width;
    }

    public final float calculateAscentHeight(Graphics2D g) {
        this.calculateSpecs(g);
        return this.ascentHeight;
    }

    public final float calculateDescentHeight(Graphics2D g) {
        this.calculateSpecs(g);
        return this.descentHeight;
    }

    public int getScriptlevelForChild(JEuclidElement child) {
        if (child.isSameNode(this.getFirstChild())) {
            return this.getAbsoluteScriptLevel();
        }
        return this.getAbsoluteScriptLevel() + 1;
    }

    public boolean hasChildPrescripts(JEuclidElement child) {
        return child.isSameNode(this.getBase()) && this.getNumprescriptcolumns() > 0;
    }

    public boolean hasChildPostscripts(JEuclidElement child) {
        return child.isSameNode(this.getBase()) && this.getNumscriptcolumns() > 0;
    }

    public String getTagName() {
        return ELEMENT;
    }

    public JEuclidElement getBase() {
        JEuclidElement base = this.getMathElement(0);
        if (base == null) {
            return new None(this.getMathBase());
        }
        return base;
    }

    public void setBase(MathMLElement base) {
        this.setMathElement(0, base);
    }

    public int getNumprescriptcolumns() {
        return this.presubscripts.size();
    }

    public int getNumscriptcolumns() {
        return this.postsubscripts.size();
    }

    public MathMLElement getPreSubScript(int colIndex) {
        return this.presubscripts.get(colIndex - 1);
    }

    public MathMLElement getPreSuperScript(int colIndex) {
        return this.presuperscripts.get(colIndex - 1);
    }

    public MathMLNodeList getPrescripts() {
        Vector<Node> list = new Vector<Node>();
        for (int i = 0; i < this.presubscripts.size(); ++i) {
            list.add(this.presubscripts.get(i));
            list.add(this.presuperscripts.get(i));
        }
        return new MathMLNodeListImpl(list);
    }

    public MathMLNodeList getScripts() {
        Vector<Node> list = new Vector<Node>();
        for (int i = 0; i < this.postsubscripts.size(); ++i) {
            list.add(this.postsubscripts.get(i));
            list.add(this.postsuperscripts.get(i));
        }
        return new MathMLNodeListImpl(list);
    }

    public MathMLElement getSubScript(int colIndex) {
        return this.postsubscripts.get(colIndex - 1);
    }

    public MathMLElement getSuperScript(int colIndex) {
        return this.postsuperscripts.get(colIndex - 1);
    }

    private void rewriteChildren() {
        int i;
        this.inRewriteChildren = true;
        NodeList childList = this.getChildNodes();
        int len = childList.getLength();
        for (i = 1; i < len; ++i) {
            this.removeChild(childList.item(1));
        }
        if (len == 0) {
            this.addMathElement(new None(this.getMathBase()));
        }
        for (i = 0; i < this.postsubscripts.size(); ++i) {
            this.addMathElement(this.postsubscripts.get(i));
            this.addMathElement(this.postsuperscripts.get(i));
        }
        int numprescripts = this.presubscripts.size();
        if (numprescripts > 0) {
            this.addMathElement(new Mprescripts(this.getMathBase()));
            for (int i2 = 0; i2 < numprescripts; ++i2) {
                this.addMathElement(this.presubscripts.get(i2));
                this.addMathElement(this.presuperscripts.get(i2));
            }
        }
        this.inRewriteChildren = false;
    }

    public MathMLElement insertPreSubScriptBefore(int colIndex, MathMLElement newScript) {
        int targetIndex = colIndex == 0 ? this.presubscripts.size() : colIndex - 1;
        this.presubscripts.add(targetIndex, (JEuclidElement)newScript);
        this.presuperscripts.add(targetIndex, new None(this.getMathBase()));
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement insertPreSuperScriptBefore(int colIndex, MathMLElement newScript) {
        int targetIndex = colIndex == 0 ? this.presubscripts.size() : colIndex - 1;
        this.presubscripts.add(targetIndex, new None(this.getMathBase()));
        this.presuperscripts.add(targetIndex, (JEuclidElement)newScript);
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement insertSubScriptBefore(int colIndex, MathMLElement newScript) {
        int targetIndex = colIndex == 0 ? this.postsubscripts.size() : colIndex - 1;
        this.postsubscripts.add(targetIndex, (JEuclidElement)newScript);
        this.postsuperscripts.add(targetIndex, new None(this.getMathBase()));
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement insertSuperScriptBefore(int colIndex, MathMLElement newScript) {
        int targetIndex = colIndex == 0 ? this.postsubscripts.size() : colIndex - 1;
        this.postsubscripts.add(targetIndex, new None(this.getMathBase()));
        this.postsuperscripts.add(targetIndex, (JEuclidElement)newScript);
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement setPreSubScriptAt(int colIndex, MathMLElement newScript) {
        int targetCol = colIndex - 1;
        if (targetCol == this.presubscripts.size()) {
            return this.insertPreSubScriptBefore(0, newScript);
        }
        this.presubscripts.set(targetCol, (JEuclidElement)newScript);
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement setPreSuperScriptAt(int colIndex, MathMLElement newScript) {
        int targetCol = colIndex - 1;
        if (targetCol == this.presuperscripts.size()) {
            return this.insertPreSuperScriptBefore(0, newScript);
        }
        this.presuperscripts.set(targetCol, (JEuclidElement)newScript);
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement setSubScriptAt(int colIndex, MathMLElement newScript) {
        int targetCol = colIndex - 1;
        if (targetCol == this.postsubscripts.size()) {
            return this.insertSubScriptBefore(0, newScript);
        }
        this.postsubscripts.set(targetCol, (JEuclidElement)newScript);
        this.rewriteChildren();
        return newScript;
    }

    public MathMLElement setSuperScriptAt(int colIndex, MathMLElement newScript) {
        int targetCol = colIndex - 1;
        if (targetCol == this.postsuperscripts.size()) {
            return this.insertSuperScriptBefore(0, newScript);
        }
        this.postsuperscripts.set(targetCol, (JEuclidElement)newScript);
        this.rewriteChildren();
        return newScript;
    }
}

