/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoot
extends AbstractJEuclidElement {
    public static final char STANDARD_ROOT_CHAR = '\u221a';
    private static final int EXTRA_VERTICAL_SPACE = 4;
    private static final float INTERNAL_SCALE_FACTOR = 100.0f;
    private final char rootChar;

    public AbstractRoot(MathBase base, char root) {
        super(base);
        this.rootChar = root;
    }

    protected abstract JEuclidElement getActualIndex();

    protected abstract List<JEuclidElement> getContent();

    @Override
    public float calculateAscentHeight(Graphics2D g) {
        List<JEuclidElement> elements = this.getContent();
        float asHeight = ElementListSupport.getAscentHeight(g, elements);
        float desHeight = ElementListSupport.getDescentHeight(g, elements);
        float height = asHeight + desHeight;
        return Math.max(asHeight + 2.0f, height / 2.0f + 2.0f - desHeight + this.getActualIndex().getHeight(g));
    }

    @Override
    public float calculateDescentHeight(Graphics2D g) {
        return ElementListSupport.getDescentHeight(g, this.getContent()) + 2.0f;
    }

    @Override
    public float calculateWidth(Graphics2D g) {
        return ElementListSupport.getWidth(g, this.getContent()) + this.getRootWidth(g) + 1.0f;
    }

    @Override
    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        List<JEuclidElement> content = this.getContent();
        JEuclidElement e2 = this.getActualIndex();
        float height1 = ElementListSupport.getHeight(g, content);
        Font font = g.getFont().deriveFont(this.getFontsizeInPoint() * 100.0f);
        GlyphVector gv = font.createGlyphVector(g.getFontRenderContext(), new char[]{this.rootChar});
        Rectangle2D gbounds = gv.getGlyphMetrics(0).getBounds2D();
        float glyphWidth = (float)gbounds.getWidth() / 100.0f;
        float glyphHeight = (float)gbounds.getHeight() / 100.0f;
        float ascent = (float)gbounds.getY() / 100.0f;
        float width2 = Math.max(e2.getWidth(g) - glyphWidth / 2.0f, 0.0f);
        float yScale = (height1 + 4.0f) / glyphHeight;
        float xScale = 1.0f;
        float y = posY + this.getDescentHeight(g);
        float x = posX + width2;
        this.drawScaledChar(g, x, y -= (ascent + glyphHeight) * yScale, xScale, yScale);
        float contentDes = ElementListSupport.getDescentHeight(g, content);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(GraphicsSupport.lineWidth(this) / 2.0f));
        float rightTopRootPoint = posY + contentDes - height1 - 2.0f;
        g.draw(new Line2D.Float(posX + (glyphWidth + width2) * xScale + 1.0f, rightTopRootPoint, posX + this.getWidth(g) - 1.0f, rightTopRootPoint));
        g.setStroke(oldStroke);
        ElementListSupport.paint(g, posX + this.getRootWidth(g) + 1.0f, posY, content);
        e2.paint(g, posX, posY + contentDes - e2.getDescentHeight(g) - height1 / 2.0f);
    }

    private void drawScaledChar(Graphics2D g, float posX, float posY, float xScale, float yScale) {
        AffineTransform transform = g.getTransform();
        AffineTransform prevTransform = g.getTransform();
        transform.scale(xScale, yScale);
        float y = posY / yScale;
        float x = posX / xScale;
        g.setTransform(transform);
        g.drawString(String.valueOf(this.rootChar), x, y);
        g.setTransform(prevTransform);
    }

    private float getRootWidth(Graphics2D g) {
        float result = 0.0f;
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        GlyphVector gv = this.getFont().createGlyphVector(context, new char[]{this.rootChar});
        result = (float)gv.getGlyphMetrics(0).getBounds2D().getWidth();
        result += Math.max(this.getActualIndex().getWidth(g) - result / 2.0f, 0.0f);
        return result;
    }
}

