/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.dom;

import java.util.List;
import java.util.Vector;
import net.sourceforge.jeuclid.dom.PartialTextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class AbstractPartialNodeImpl
implements Node {
    private static final String COULD_NOT_FIND_NODE = "Could not find node: ";
    private final List<Node> children = new Vector<Node>();
    private Node parent;

    public final String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("lookupNamespaceURI");
    }

    public final void normalize() {
        throw new UnsupportedOperationException("normalize");
    }

    public final org.w3c.dom.NodeList getChildNodes() {
        return new NodeList(this.children);
    }

    public final Node getFirstChild() {
        try {
            return this.children.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public final boolean isSameNode(Node other) {
        return this.equals(other);
    }

    public Node appendChild(Node newChild) {
        if (newChild instanceof AbstractPartialNodeImpl) {
            this.children.add(newChild);
            ((AbstractPartialNodeImpl)newChild).parent = this;
            return newChild;
        }
        throw new IllegalArgumentException("Can only add children of type " + AbstractPartialNodeImpl.class.getName() + " to " + this.getClass().getName());
    }

    public String getTextContent() {
        StringBuilder builder = new StringBuilder();
        for (Node n : this.children) {
            builder.append(n.getTextContent());
        }
        return builder.toString();
    }

    public void setTextContent(String newTextContent) {
        this.children.clear();
        if (newTextContent != null && newTextContent.length() > 0) {
            this.children.add(new PartialTextImpl(newTextContent));
        }
    }

    public final Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException("cloneNode");
    }

    public String getNodeValue() {
        return null;
    }

    public final String getNamespaceURI() {
        return null;
    }

    public final Node getParentNode() {
        return this.parent;
    }

    public final String getBaseURI() {
        throw new UnsupportedOperationException("getBaseURI");
    }

    public final String getPrefix() {
        throw new UnsupportedOperationException("getPrefix");
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public final boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    public final boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("isDefaultNamespace");
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        for (int i = 0; i < this.children.size(); ++i) {
            Node oldChildAtIndex = this.children.get(i);
            if (!oldChildAtIndex.equals(oldChild)) continue;
            this.children.set(i, newChild);
            return oldChildAtIndex;
        }
        throw new DOMException(8, COULD_NOT_FIND_NODE + oldChild);
    }

    public final Node insertBefore(Node newChild, Node refChild) {
        throw new UnsupportedOperationException("insertBefore");
    }

    public final boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException("isEqualNode");
    }

    public final Node getNextSibling() {
        Node retval;
        try {
            List<Node> parentsChildren = ((AbstractPartialNodeImpl)this.parent).children;
            retval = parentsChildren.get(parentsChildren.indexOf(this) + 1);
        }
        catch (NullPointerException ne) {
            retval = null;
        }
        catch (IndexOutOfBoundsException iobe) {
            retval = null;
        }
        return retval;
    }

    public final boolean hasAttributes() {
        return this.getAttributes().getLength() > 0;
    }

    public final short compareDocumentPosition(Node other) {
        throw new UnsupportedOperationException("compareDocumentPosition");
    }

    public final Node removeChild(Node oldChild) {
        for (int i = 0; i < this.children.size(); ++i) {
            Node oldChildAtIndex = this.children.get(i);
            if (!oldChildAtIndex.equals(oldChild)) continue;
            this.children.remove(i);
            return oldChildAtIndex;
        }
        throw new DOMException(8, COULD_NOT_FIND_NODE + oldChild);
    }

    public final Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("getFeature");
    }

    public final Node getLastChild() {
        List<Node> theChildren = this.children;
        int size = theChildren.size();
        if (size == 0) {
            return null;
        }
        return theChildren.get(size - 1);
    }

    public String getLocalName() {
        return null;
    }

    public final Document getOwnerDocument() {
        throw new UnsupportedOperationException("getOwnerDocument");
    }

    public final Node getPreviousSibling() {
        throw new UnsupportedOperationException("getPreviousSibling");
    }

    public final boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException("isSupported");
    }

    public final String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("lookupPrefix");
    }

    public final void setNodeValue(String nodeValue) {
        throw new UnsupportedOperationException("setNodeValue");
    }

    public final void setPrefix(String prefix) {
        throw new UnsupportedOperationException("setPrefix");
    }

    public final Object getUserData(String key) {
        throw new UnsupportedOperationException("getUserData");
    }

    public final Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("setUserData");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeList
    implements org.w3c.dom.NodeList {
        private final List<Node> children;

        protected NodeList(List<Node> childs) {
            this.children = childs;
        }

        @Override
        public final int getLength() {
            return this.children.size();
        }

        @Override
        public final Node item(int index) {
            return this.children.get(index);
        }
    }
}

