/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Converter {
    public static final String TYPE_SVG = "image/svg+xml";
    public static final String EXTENSION_SVG = "svg";

    private Converter() {
    }

    public static boolean convert(File inFile, File outFile, String outFileType) throws IOException {
        return net.sourceforge.jeuclid.converter.Converter.getConverter().convert(inFile, outFile, outFileType) != null;
    }

    public static BufferedImage render(Document doc, Map<ParameterKey, String> params) throws SAXException, IOException {
        return net.sourceforge.jeuclid.converter.Converter.getConverter().render(MathMLParserSupport.createMathBaseFromDocument(doc, params));
    }

    public static boolean convert(File inFile, File outFile, Map<ParameterKey, String> params) throws IOException {
        return net.sourceforge.jeuclid.converter.Converter.getConverter().convert(inFile, outFile, params) != null;
    }

    public static boolean convert(Document doc, File outFile, Map<ParameterKey, String> params) throws IOException {
        return net.sourceforge.jeuclid.converter.Converter.getConverter().convert((Node)doc, outFile, params) != null;
    }

    public static List<String> getAvailableOutfileTypes() {
        return new Vector<String>(ConverterRegistry.getRegisty().getAvailableOutfileTypes());
    }

    public static String getSuffixForMimeType(String mimeType) {
        return ConverterRegistry.getRegisty().getSuffixForMimeType(mimeType);
    }

    public static String getMimeTypeForSuffix(String suffix) {
        return ConverterRegistry.getRegisty().getMimeTypeForSuffix(suffix);
    }
}

