/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.ExportProgress;
import com.inet.viewer.Progress;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerUtils;
import java.applet.Applet;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;

public class AppletViewerContext
implements ViewerContext {
    private final Applet a;
    private final ViewerContext b;

    AppletViewerContext(ViewerContext viewerContext, Applet applet) {
        this.b = viewerContext;
        this.a = applet;
    }

    @Override
    public ExportProgress export(ReportView view) {
        return this.b.export(view);
    }

    @Override
    public Progress print(ReportView view) {
        return this.b.print(view);
    }

    @Override
    public void showError(Throwable e2, Object source) {
        this.b.showError(e2, source);
    }

    @Override
    public void showInfo() {
        this.b.showInfo();
    }

    @Override
    public void showStatusMessage(ReportView view, String message, boolean isError) {
        this.b.showStatusMessage(view, message, isError);
    }

    @Override
    public void showUrl(String url, Properties props) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url);
        if (props != null && props.size() > 0) {
            stringBuilder.append('?');
            String string = (String)props.remove("stacktrace");
            Enumeration<Object> enumeration = props.keys();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append('&');
                }
                String string2 = (String)enumeration.nextElement();
                stringBuilder.append(string2);
                stringBuilder.append('=');
                try {
                    stringBuilder.append(URLEncoder.encode(props.getProperty(string2), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            if (string != null) {
                stringBuilder.append("&stacktrace=");
                try {
                    stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (stringBuilder.length() > 2048) {
            stringBuilder.setLength(2048);
            int n2 = stringBuilder.lastIndexOf("%");
            if (n2 > stringBuilder.length() - 3) {
                stringBuilder.setLength(n2);
            }
        }
        this.a(stringBuilder.toString());
    }

    private void a(String string) throws MalformedURLException {
        try {
            if (ViewerUtils.useDesktopMethod("browse", new URI(string))) {
                return;
            }
        }
        catch (Throwable throwable) {
            ViewerUtils.debug("java.awt.Desktop not available. Attempting showDocument.");
        }
        this.a.getAppletContext().showDocument(new URL(string), "_blank");
    }

    public ViewerContext getInnerContext() {
        return this.b;
    }

    @Override
    public boolean showPrompts(PromptData[] prompts, RenderData renderData) {
        return this.b.showPrompts(prompts, renderData);
    }

    @Override
    public void showHelp(String helpPageKey, Component comp) {
        URL uRL = this.a.getDocumentBase();
        try {
            URL uRL2 = new URL(uRL, "../help/#/" + helpPageKey);
            this.showUrl(uRL2.toString(), null);
        }
        catch (MalformedURLException malformedURLException) {
            this.showError(malformedURLException, comp);
        }
    }
}

