/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user.fields;

import com.inet.annotations.InternalApi;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.id.GUID;
import com.inet.search.tokenizers.EmailAddressTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

@InternalApi
public class FieldEmail
extends UserField<String> {
    public static final String KEY = "email";
    private static final int VALUE_LENGTH_LIMIT = 100;

    public FieldEmail() {
        super(KEY, "", FieldTypeFactory.auto().withTokenizer(FieldEmail.a()).withSearchPrio(1000));
    }

    private static SearchTokenizer a() {
        EmailAddressTokenizer emailAddressTokenizer = new EmailAddressTokenizer();
        return (object, n2) -> {
            Set<String> set = emailAddressTokenizer.tokens(object, n2);
            if (set.isEmpty() && n2 == 3) {
                return Collections.singleton(null);
            }
            return set;
        };
    }

    @Override
    public String getValidOrDefaultValue(String value, @Nullable GUID entryID) {
        if (value == null) {
            return "";
        }
        return EmailAddressHelper.get().getValidOrDefaultValue(this, value, 100, entryID);
    }

    @Override
    public void validate(String value) {
        super.validate(value);
        BasicFieldValidation.throwIfNull(value);
        BasicFieldValidation.throwIfLengthExceedsLimit(value, 100);
        EmailAddressHelper.get().throwIfContainsInvalidEmailAddresses(value);
    }
}

