/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;

public abstract class DoubleGroupFieldDefinition
extends GroupFieldDefinition<Double> {
    public DoubleGroupFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_double", prio);
    }

    public DoubleGroupFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public FieldValue getFieldValue(UserGroupInfo userGroup) {
        Double d2 = 0.0;
        if (userGroup != null) {
            d2 = (Double)userGroup.getValue(UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey()));
        }
        FieldValue fieldValue = new FieldValue(d2 == null ? null : d2.toString());
        fieldValue.setVisibleInPreview(d2 != null && d2.intValue() > 0);
        return fieldValue;
    }

    @Override
    public Double convertFromString(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }
}

