/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.resultlinefactory;

import com.inet.lib.util.StringFunctions;
import com.inet.search.ResultLineFactory;
import com.inet.search.index.SearchTagProvider;
import com.inet.search.utils.ShortenLineUtils;
import com.inet.search.utils.ShortenedLineHolder;
import com.inet.search.utils.UmlautsUtils;
import com.inet.shared.search.HtmlBackgroundHighlightingTags;
import com.inet.shared.search.HtmlHighlightingTags;
import com.inet.shared.search.IntRangeRightValueComparator;
import com.inet.shared.search.PositiveIntRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultResultLineFactory
implements ResultLineFactory {
    private static final String INVALID_NUMBER_OF_MAX_CHARACTERS_IN_RESULT_LINE_MSG = "Max number of characters in result line has to be greater than 0.";
    private static final int DEFAULT_MAX_NUMBER_OF_CHARACTERS_IN_RESULT_LINE = 200;
    private final HtmlHighlightingTags a = new HtmlBackgroundHighlightingTags();
    private int b = 200;

    @Override
    public String createFirstResultLine(Map<String, List<String>> matchedElements, String displayName, List<String> fieldsIncludeInDisplayName) {
        displayName = ShortenLineUtils.shortenIfNecessary(displayName, true, this.b);
        List<String> list = this.a(fieldsIncludeInDisplayName, matchedElements);
        List<PositiveIntRange> list2 = this.b(displayName, list);
        return this.a(displayName, list2);
    }

    private List<String> a(List<String> list, Map<String, List<String>> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(map.keySet());
        for (String string : list) {
            if (!arrayList2.contains(string)) continue;
            for (String string2 : map.get(string)) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    @Override
    public String createSecondResultLine(Map<String, List<String>> matchedElements, Map<String, Object> cacheEntry, String fieldKeyForSecondResultLine, @Nullable SearchTagProvider searchTagProvider) {
        if (fieldKeyForSecondResultLine == null) {
            return null;
        }
        boolean bl = matchedElements.containsKey(fieldKeyForSecondResultLine);
        if (bl) {
            return this.a(matchedElements, cacheEntry, fieldKeyForSecondResultLine, searchTagProvider);
        }
        return this.b(cacheEntry, fieldKeyForSecondResultLine, searchTagProvider);
    }

    private String a(Map<String, List<String>> map, Map<String, Object> map2, String string, @Nullable SearchTagProvider searchTagProvider) {
        String string2;
        List<String> list;
        String string3 = DefaultResultLineFactory.a(map2, string, searchTagProvider);
        ShortenedLineHolder shortenedLineHolder = ShortenLineUtils.shortenResultLine(string3, list = map.get(string), this.b);
        PositiveIntRange positiveIntRange = shortenedLineHolder.getOccurrenceIndexes();
        if (positiveIntRange != null) {
            String string4 = shortenedLineHolder.getLine();
            int n2 = 0;
            for (String string5 : list) {
                int n3 = ShortenLineUtils.replaceWithPlaceMakers(string5).length();
                n2 = Math.max(n3, n2);
            }
            string3 = ShortenLineUtils.replaceWithPlaceMakers(string3);
            int n4 = Math.max(positiveIntRange.getLeft() - n2, 0);
            int n5 = Math.min(positiveIntRange.getRight() + n2, string3.length());
            String string6 = string3.substring(n4, n5).replace("\u2017", "");
            int n6 = positiveIntRange.getLeft() - n4;
            int n7 = n5 - positiveIntRange.getRight();
            positiveIntRange = new PositiveIntRange(n6, ShortenLineUtils.replaceWithPlaceMakers(string6).length() - n7);
            List<PositiveIntRange> list2 = this.b(string6, list);
            List<PositiveIntRange> list3 = this.a(list2, positiveIntRange);
            string2 = this.a(string4, list3);
        } else {
            List<PositiveIntRange> list4 = this.b(string3, list);
            string2 = this.a(string3, list4);
        }
        return this.combineFieldNameWithValue(string, string2, searchTagProvider);
    }

    @Nonnull
    private static String a(Map<String, Object> map, String string, @Nullable SearchTagProvider searchTagProvider) {
        Object object = map.get(string);
        if (searchTagProvider != null) {
            return searchTagProvider.getTag(string).getDisplayValue(object);
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private List<PositiveIntRange> a(List<PositiveIntRange> list, PositiveIntRange positiveIntRange) {
        ArrayList<PositiveIntRange> arrayList = new ArrayList<PositiveIntRange>();
        int n2 = positiveIntRange.getLeft();
        int n3 = positiveIntRange.getRight();
        for (PositiveIntRange positiveIntRange2 : list) {
            boolean bl;
            int n4 = positiveIntRange2.getLeft();
            int n5 = positiveIntRange2.getRight();
            int n6 = 0;
            int n7 = 0;
            boolean bl2 = bl = n2 > 0;
            if (n4 <= n2 && n5 > n2) {
                n6 = n2;
            } else {
                if (n4 <= n2 || n4 >= n3) continue;
                n6 = n4;
            }
            if (n5 <= n3) {
                n7 = n5;
            } else if (n5 > n3) {
                n7 = n3;
            }
            n6 = bl ? n6 - n2 + 1 : n6 - n2;
            n7 = bl ? n7 - n2 + 1 : n7 - n2;
            arrayList.add(new PositiveIntRange(n6, n7));
        }
        return arrayList;
    }

    private String b(Map<String, Object> map, String string, @Nullable SearchTagProvider searchTagProvider) {
        String string2 = DefaultResultLineFactory.a(map, string, searchTagProvider);
        String string3 = ShortenLineUtils.shortenIfNecessary(string2, false, this.b);
        string3 = string3.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return this.combineFieldNameWithValue(string, string3, searchTagProvider);
    }

    protected String combineFieldNameWithValue(String fieldName, String value, @Nullable SearchTagProvider searchTagProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        if (searchTagProvider != null) {
            stringBuilder.append("<b>").append(StringFunctions.encodeHTML(searchTagProvider.getTag(fieldName).getDisplayName(), false)).append("</b>: ");
        }
        return stringBuilder.append(value).toString();
    }

    private String a(String string, List<PositiveIntRange> list) {
        string = string.replace('<', '\u2329').replace('>', '\u232a');
        string = ShortenLineUtils.replaceWithPlaceMakers(string);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (PositiveIntRange positiveIntRange : list) {
            stringBuilder.replace(positiveIntRange.getRight(), positiveIntRange.getRight(), this.a.getClosingTag());
            stringBuilder.replace(positiveIntRange.getLeft(), positiveIntRange.getLeft(), this.a.getOpeningTag());
        }
        return stringBuilder.toString().replaceAll("\u2026", "&hellip;").replaceAll("\u2329", "&lt;").replaceAll("\u232a", "&gt;").replaceAll("\u2017", "");
    }

    private List<PositiveIntRange> b(String string, List<String> list) {
        String string2 = string.toLowerCase();
        String string3 = ShortenLineUtils.replaceWithPlaceMakers(string2);
        String string4 = UmlautsUtils.replaceUmlauts(string2);
        string4 = UmlautsUtils.flattenToAscii(string4);
        List<PositiveIntRange> list2 = this.a(string4, string3, list);
        Collections.sort(list2, new IntRangeRightValueComparator());
        ArrayList<PositiveIntRange> arrayList = new ArrayList<PositiveIntRange>();
        PositiveIntRange positiveIntRange = null;
        for (PositiveIntRange positiveIntRange2 : list2) {
            if (positiveIntRange == null) {
                positiveIntRange = positiveIntRange2;
                continue;
            }
            if (positiveIntRange2.getRight() >= positiveIntRange.getLeft()) {
                positiveIntRange = new PositiveIntRange(Math.min(positiveIntRange.getLeft(), positiveIntRange2.getLeft()), positiveIntRange.getRight());
                continue;
            }
            arrayList.add(positiveIntRange);
            positiveIntRange = positiveIntRange2;
        }
        if (positiveIntRange != null) {
            arrayList.add(positiveIntRange);
        }
        return arrayList;
    }

    private List<PositiveIntRange> a(String string, String string2, List<String> list) {
        ArrayList<PositiveIntRange> arrayList = new ArrayList<PositiveIntRange>();
        for (String string3 : list) {
            int n2;
            int n3 = 0;
            String string4 = string3.toLowerCase();
            string4 = UmlautsUtils.replaceUmlauts(string4);
            string4 = UmlautsUtils.flattenToAscii(string4);
            int n4 = string4.length();
            while ((n2 = string.indexOf(string4, n3)) != -1) {
                if (string2.charAt(n2) == '\u2017' || n2 > 0 && Character.isLetterOrDigit(string2.charAt(n2 - 1))) {
                    ++n3;
                    continue;
                }
                int n5 = n2 + n4;
                arrayList.add(new PositiveIntRange(n2, n5));
                n3 = n5;
            }
        }
        return arrayList;
    }

    public void setMaxNumberOfCharactersInResultLine(int maxNumberOfCharactersInResultLine) throws IllegalArgumentException {
        if (maxNumberOfCharactersInResultLine <= 0) {
            throw new IllegalArgumentException(INVALID_NUMBER_OF_MAX_CHARACTERS_IN_RESULT_LINE_MSG);
        }
        this.b = maxNumberOfCharactersInResultLine;
    }

    public int getMaxNumberOfCharactersInResultLine() {
        return this.b;
    }
}

