/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.command;

import com.inet.annotations.InternalApi;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PhraseSearchExpression
implements SearchExpression {
    private final String a;
    @Nonnull
    private final SearchCondition.SearchTermOperator b;
    @Nonnull
    private final String c;
    @Nonnull
    private final Collection<String> d;

    public PhraseSearchExpression(@Nullable String leftOperand, @Nonnull SearchCondition.SearchTermOperator operator, @Nonnull String phrase, @Nonnull Collection<String> tokens) {
        this.a = leftOperand;
        this.b = Objects.requireNonNull(operator);
        this.c = Objects.requireNonNull(phrase);
        if (!(tokens.size() != 0 || phrase.trim().isEmpty() && leftOperand != null)) {
            throw new IllegalArgumentException();
        }
        this.d = Objects.requireNonNull(tokens);
    }

    @Override
    public SearchExpression.Type getType() {
        return SearchExpression.Type.Phrase;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Nullable
    public String getLeftOperand() {
        return this.a;
    }

    @Nonnull
    public SearchCondition.SearchTermOperator getOperator() {
        return this.b;
    }

    @Nonnull
    public String getPhrase() {
        return this.c;
    }

    @Nonnull
    public Collection<String> getTokens() {
        return this.d;
    }

    public int hashCode() {
        return Objects.hash(this.a, this.c);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PhraseSearchExpression phraseSearchExpression = (PhraseSearchExpression)obj;
        return Objects.equals(this.a, phraseSearchExpression.a) && Objects.equals(this.c, phraseSearchExpression.c);
    }

    public static String normalize(String str) {
        str = str.toLowerCase().trim();
        int n2 = str.length();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(n2);
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': 
                case '\u00a0': {
                    if (bl) continue block3;
                    stringBuilder.append(' ');
                    bl = true;
                    continue block3;
                }
                default: {
                    stringBuilder.append(c2);
                    bl = false;
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void toPhrase(@Nonnull StringBuilder phraseBuilder, @Nonnull IndexSearchEngine<?> searchEngine, boolean toGenericLocale) {
        String string = this.a;
        if (string != null) {
            String string2 = toGenericLocale ? string : searchEngine.getTag(string).getDisplayName();
            phraseBuilder.append(TextSearchCommandBuilder.normalizedTagDisplayName(string2));
            phraseBuilder.append(':');
        }
        if (this.b != SearchCondition.SearchTermOperator.Equals) {
            phraseBuilder.append("<>");
        }
        char c2 = this.c.indexOf(34) < 0 ? (char)'\"' : '\'';
        phraseBuilder.append(c2).append(this.c).append(c2);
    }
}

