/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.website;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.http.utils.UserAgent;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.website.WellKnownWebsites;
import com.inet.plugin.website.data.WebsiteDownloadResponseData;
import com.inet.shared.utils.Version;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.net.ssl.HttpsURLConnection;

@InternalApi
public class WebsiteDownloadConnector {
    public static final String WEBSITE_DOWNLOAD_VERSION_EXTENSION = ".chng";
    private static final I18nMessages a = new I18nMessages("com.inet.plugin.structure.i18n.ConfigStructure", WebsiteDownloadConnector.class);
    private Version b;
    private String c;
    private String d;

    public static WebsiteDownloadConnector connectorFor(String product, String variant, String majorVersion) {
        WebsiteDownloadConnector websiteDownloadConnector = new WebsiteDownloadConnector();
        websiteDownloadConnector.init(product, variant, majorVersion);
        return websiteDownloadConnector;
    }

    protected void init() {
        this.init(ServerPluginManager.getInstance().getCorePluginId(), null, null);
    }

    protected void init(String product, String variant, String majorVersion) {
        this.c = product;
        this.d = majorVersion;
        if (!StringFunctions.isEmpty(variant)) {
            this.c = this.c + "-" + variant;
        }
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        this.b = applicationDescription.getVersion();
    }

    public Version getSystemVersion() {
        return this.b;
    }

    public WebsiteDownloadResponseData getWebsiteDownloadResponseData(boolean beta) throws IOException {
        return this.getWebsiteDownloadResponseData(null, beta, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebsiteDownloadResponseData getWebsiteDownloadResponseData(Version version, boolean beta, boolean checkNewestMajorVersion) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.createConnection(version, beta, checkNewestMajorVersion, null);
            if (httpURLConnection == null) {
                WebsiteDownloadResponseData websiteDownloadResponseData = null;
                return websiteDownloadResponseData;
            }
            Json json = new Json();
            HashMap<Object, Map<String, String>> hashMap = new HashMap<Object, Map<String, String>>();
            WebsiteDownloadResponseData websiteDownloadResponseData = (WebsiteDownloadResponseData)json.fromJson(httpURLConnection.getInputStream(), (Type)((Object)WebsiteDownloadResponseData.class), (Map<Object, Map<String, String>>)hashMap, null);
            return websiteDownloadResponseData;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    protected HttpsURLConnection createConnection(Version version, boolean checkNewestMajorVersion) throws IOException {
        return this.createConnection(version, false, checkNewestMajorVersion, null);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="No client input is used")
    protected HttpsURLConnection createConnection(Version version, boolean beta, boolean checkNewestMajorVersion, @Nullable Locale locale) throws IOException {
        HttpsURLConnection httpsURLConnection;
        block14: {
            Object object;
            Object object2;
            String string;
            LogManager.getApplicationLogger().debug("Requesting data from the vendor website.");
            Object object3 = "latest";
            Version version2 = null;
            if (!StringFunctions.isEmpty(this.d)) {
                object3 = this.d + "-" + (String)object3;
            } else if (!checkNewestMajorVersion && !StringFunctions.isEmpty(string = ((LicenseInfo)(object2 = ConfigKeyParser.getCurrent())).getAttributes().get("version"))) {
                version2 = new Version(string);
                object3 = version2.isHigherThan(this.b) ? version2.getMajor() + "-" + (String)object3 : this.b.getMajor() + "-" + (String)object3;
            }
            object2 = new URL(this.getUpdateCheckBaseUrl(beta) + this.c + "-" + (String)object3 + WEBSITE_DOWNLOAD_VERSION_EXTENSION);
            int n2 = 5;
            httpsURLConnection = null;
            while (true) {
                if (n2-- <= 0) {
                    throw new IOException("Retries exceeded.");
                }
                httpsURLConnection = (HttpsURLConnection)((URL)object2).openConnection();
                httpsURLConnection.setRequestProperty("User-Agent", UserAgent.getUserAgent());
                httpsURLConnection.setRequestMethod(version == null ? "GET" : "POST");
                httpsURLConnection.setConnectTimeout(10000);
                httpsURLConnection.setReadTimeout(10000);
                httpsURLConnection.setInstanceFollowRedirects(version != null);
                if (locale != null) {
                    httpsURLConnection.setRequestProperty("Accept-Language", locale.toString());
                }
                if (version != null) {
                    httpsURLConnection.setDoOutput(true);
                    httpsURLConnection.setRequestProperty("Accept", "text/x-markdown");
                    byte[] byArray = ("version=" + version.toString()).getBytes(StandardCharsets.UTF_8);
                    object = new DataOutputStream(httpsURLConnection.getOutputStream());
                    try {
                        ((FilterOutputStream)object).write(byArray);
                    }
                    finally {
                        ((FilterOutputStream)object).close();
                    }
                }
                httpsURLConnection.connect();
                int n3 = httpsURLConnection.getResponseCode();
                if (n3 == 200) break block14;
                if (n3 < 300 || n3 >= 400 || (object = httpsURLConnection.getHeaderField("Location")) == null || ((String)object).length() <= 0 || !((String)object).startsWith(((URL)object2).getProtocol())) break;
                object2 = new URL((String)object);
            }
            httpsURLConnection.disconnect();
            if (StringFunctions.isEmpty(this.d) && !checkNewestMajorVersion && version2 != null && version2.isHigherThan(this.b)) {
                object = WebsiteDownloadConnector.connectorFor(this.c, null, "" + this.b.getMajor());
                return ((WebsiteDownloadConnector)object).createConnection(version, beta, checkNewestMajorVersion, locale);
            }
            LogManager.getApplicationLogger().debug("Could not fetch information from vendor website: " + ((URL)object2).toExternalForm());
            return null;
        }
        return httpsURLConnection;
    }

    protected String getChangesDocument(@Nonnull Locale locale, boolean beta, boolean requestNewestMajorVersion) throws IOException {
        HttpsURLConnection httpsURLConnection = this.createConnection(this.b, beta, requestNewestMajorVersion, locale);
        if (httpsURLConnection == null) {
            return a.getMsg("website.download.couldNotLoadChanges", new Object[0]);
        }
        return IOFunctions.readString(httpsURLConnection.getInputStream(), StandardCharsets.UTF_8);
    }

    protected String getUpdateCheckBaseUrl(boolean beta) {
        return WellKnownWebsites.WEBSITE_DOWNLOAD_BASE_URL + (beta ? "beta/" : "");
    }
}

