/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.io.URLProtocolManager;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.persistence.file.FilePersistenceFactory;
import com.inet.persistence.spi.PersistenceFactory;
import com.inet.persistence.spi.PersistencePreferences;
import com.inet.persistence.spi.PersistenceURI;
import com.inet.persistence.spi.PersistenceURLHandler;
import com.inet.persistence.spi.WrappedPreferences;
import com.inet.thread.ServerLock;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.concurrent.ForkJoinPool;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public interface Persistence {
    public static Persistence getInstance() {
        return Singleton.a();
    }

    public static Persistence getRecoveryEnabledInstance() {
        return Singleton.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<Singleton> clazz = Singleton.class;
        synchronized (Singleton.class) {
            if (MaintenanceMode.getState() != MaintenanceMode.IN_PROGRESS) {
                throw new IllegalStateException("Reset outside the maintenance mode.");
            }
            Singleton.a = null;
            Singleton.b = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    default public String getUID() {
        return null;
    }

    @Nonnull
    public PersistenceEntry resolve(@Nonnull String var1) throws NullPointerException, IllegalArgumentException;

    public static boolean isFilePersistence() {
        return PersistenceURI.isFilePersistence();
    }

    @Nonnull
    public static Preferences getPreferences(boolean isUser) {
        if (Persistence.isFilePersistence()) {
            return new WrappedPreferences(isUser ? Preferences.userRoot() : Preferences.systemRoot());
        }
        return new PersistencePreferences(Persistence.getInstance(), isUser);
    }

    @Nonnull
    public EventLogPersistence getEventLogPersistence(String var1);

    public <T> void registerListener(@Nonnull PersistenceListener<T> var1);

    public <T> void sendEvent(@Nonnull T var1);

    public int getNodeCount();

    public void registerNodeListener(@Nonnull PersistenceListener<Boolean> var1);

    public <ID> SearchIndexPersistence<ID> getSearchIndexPersistence(@Nonnull String var1);

    @Nullable
    public ServerLock tryLock(@Nonnull String var1);

    @Nullable
    default public ServerLock tryLock(@Nonnull GUID uid) {
        return this.tryLock(uid.toString());
    }

    @Nullable
    default public ServerLock tryLock(@Nonnull Class<?> key) {
        return this.tryLock(key.getName());
    }

    @Nullable
    public ServerLock tryReadLock(@Nonnull String var1);

    @Nullable
    public ServerLock tryWriteLock(@Nonnull String var1);

    @Nonnull
    public ServerLock getReadLock(@Nonnull String var1, long var2);

    @Nonnull
    public ServerLock getWriteLock(@Nonnull String var1, long var2);

    public static abstract class Singleton {
        private static Persistence a;
        private static Persistence b;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Persistence a() {
            Persistence persistence = a;
            if (persistence != null) return persistence;
            Class<Singleton> clazz = Singleton.class;
            synchronized (Singleton.class) {
                if (a != null) return a;
                a = Singleton.a(false);
                return a;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Persistence b() {
            Persistence persistence = b;
            if (persistence != null) return persistence;
            Class<Singleton> clazz = Singleton.class;
            synchronized (Singleton.class) {
                if (b != null) return b;
                b = Singleton.a(true);
                return b;
            }
        }

        @Nonnull
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
        private static Persistence a(boolean bl) {
            String string = PersistenceURI.getPersistenceURI();
            String string2 = ConfigurationManager.getRecoveryConfiguration();
            if (bl && string2 == null) {
                return Singleton.a();
            }
            if (!bl && string2 != null) {
                string = null;
            }
            try {
                Object throwable;
                Object object;
                Serializable serializable2;
                if (StringFunctions.isEmpty(string)) {
                    FilePersistence filePersistence = FilePersistenceFactory.createFilePersistenceFactory(bl ? string2 : null).createInstance();
                    Singleton.a("Persistence: " + String.valueOf(filePersistence.getPersistenceFolder()));
                    return filePersistence;
                }
                ClassLoader classLoader = Singleton.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                ArrayList<URL> arrayList = new ArrayList<URL>();
                File[] fileArray = new File(PersistenceURI.getPersistenceLibDir()).listFiles();
                if (fileArray != null) {
                    for (Serializable serializable2 : fileArray) {
                        object = serializable2.getName().toLowerCase();
                        if (!((String)object).endsWith(".jar")) continue;
                        try {
                            arrayList.add(serializable2.toURI().toURL());
                        }
                        catch (MalformedURLException object2) {
                            // empty catch block
                        }
                    }
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), classLoader);
                ServiceLoader<PersistenceFactory> serviceLoader = ServiceLoader.load(PersistenceFactory.class, uRLClassLoader);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Persistence persistence = null;
                serializable2 = null;
                object = serviceLoader.iterator();
                do {
                    try {
                        if (!object.hasNext()) break;
                        throwable = (PersistenceFactory)object.next();
                        arrayList2.add(throwable.getClass().getName());
                        persistence = throwable.createPersistence(string);
                    }
                    catch (Throwable throwable2) {
                        serializable2 = throwable2;
                        throwable2.printStackTrace(System.err);
                    }
                } while (persistence == null);
                if (persistence == null) {
                    throwable = new Error("No Persistence loaded for config: " + string + "\n\tsearch in libraries: " + String.valueOf(arrayList) + "\n\tfound factories: " + String.valueOf(arrayList2));
                    if (serializable2 != null) {
                        ((Throwable)throwable).addSuppressed((Throwable)serializable2);
                    }
                    throw throwable;
                }
                Singleton.a("Persistence: " + string);
                return persistence;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                ErrorCode.throwAny(throwable);
                return null;
            }
        }

        private static void a(Object object) {
            ForkJoinPool.commonPool().execute(() -> {
                ConfigurationManager.getInstance().getCurrent();
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LogManager.getLogger("Persistence").info(object);
                LogManager.getConfigLogger().info(object);
            });
        }

        static {
            URLProtocolManager.register("persistence", new PersistenceURLHandler());
        }
    }
}

