/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.UTF8StreamReader;
import com.inet.logging.FileArchiver;
import com.inet.logging.LogManager;
import com.inet.persistence.spi.PersistenceHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

@InternalApi
public abstract class EventLogFileArchiver
extends FileArchiver {
    public static Iterator<String[]> getEvents(final InputStream inputStream, final int columnCount) {
        return new Iterator<String[]>(){
            private String[] c;
            private UTF8StreamReader d;
            private BufferedReader e;
            private boolean f;
            {
                this.c = new String[columnCount];
                this.d = new UTF8StreamReader(new FastBufferedInputStream(inputStream));
                this.e = new BufferedReader(this.d);
            }

            @Override
            public boolean hasNext() {
                if (!this.f) {
                    try {
                        String string;
                        while ((string = this.e.readLine()) != null) {
                            try {
                                if (!PersistenceHelper.parseEventLine(string, this.c)) continue;
                                this.f = true;
                                return true;
                            }
                            catch (Throwable throwable) {
                                LogManager.getLogger("Statistics").debug(throwable);
                            }
                        }
                        this.e.close();
                    }
                    catch (IOException iOException) {
                        LogManager.getLogger("Statistics").debug(iOException);
                    }
                }
                return this.f;
            }

            @Override
            public String[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.f = false;
                return this.c;
            }

            protected void finalize() throws Throwable {
                this.e.close();
            }
        };
    }
}

