/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.list;

import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public final class StringList
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 8534014732794122033L;
    private final Object a = new Object();
    private String[] b;
    private int c;
    private int d;

    public StringList() {
        this(10);
    }

    public StringList(Vector v) {
        this(v.size());
        v.copyInto(this.b);
        this.c = v.size();
    }

    public StringList(String[] s) {
        this(s.length);
        this.addAll(s);
    }

    public StringList(StringList o2) {
        this(o2.size());
        System.arraycopy(o2.b, 0, this.b, 0, o2.c);
        this.c = o2.c;
    }

    public StringList(int capacity) {
        this(capacity, 0);
    }

    public StringList(int capacity, int capacityIncrement) {
        this.b = new String[capacity];
        this.d = capacityIncrement;
    }

    public final String elementAt(int idx) {
        if (idx < this.c) {
            return this.b[idx];
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public final void setCapacity(int capacity) {
        if (capacity < this.c) {
            this.c = capacity;
        }
        if (capacity != this.b.length) {
            String[] stringArray = new String[capacity];
            System.arraycopy(this.b, 0, stringArray, 0, this.c);
            this.b = stringArray;
        }
    }

    private final void a(int n2) {
        int n3 = this.b.length;
        if (n2 > n3) {
            if (this.d > 0) {
                while ((n3 += this.d) < n2) {
                }
            } else {
                if (n3 == 0) {
                    n3 = 1;
                }
                while ((n3 = 2 * n3) < n2) {
                }
            }
        } else if (n3 > 100000 && n3 > 2 * n2) {
            n3 = this.d > 0 ? n2 + this.d : n2 * 2;
        }
        int n4 = n3;
        if (n4 != this.b.length) {
            this.setCapacity(n4);
        }
    }

    public final void addElement(String o2) {
        if (this.c >= this.b.length) {
            this.a(this.c + 1);
        }
        this.b[this.c] = o2;
        ++this.c;
    }

    public final void insertElementAt(String o2, int index) {
        if (index > this.c) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.a(this.c + 1);
        System.arraycopy(this.b, index, this.b, index + 1, this.c - index);
        this.b[index] = o2;
        ++this.c;
    }

    public final String removeElementAt(int idx) {
        String string = this.b[idx];
        if (idx < this.c - 1) {
            System.arraycopy(this.b, idx + 1, this.b, idx, this.c - idx - 1);
        }
        this.b[--this.c] = null;
        return string;
    }

    public final int size() {
        return this.c;
    }

    public final void setSize(int size) {
        for (int i2 = size; i2 < this.c; ++i2) {
            this.b[i2] = null;
        }
        this.a(size);
        this.c = size;
    }

    public final void clear() {
        this.setSize(0);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            out.writeObject(this.b[i2]);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.c = in.readInt();
        if (this.b.length < this.c) {
            this.b = new String[this.c];
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.b[i2] = (String)in.readObject();
        }
    }

    public final int indexOf(String o2) {
        if (o2 == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!o2.equals(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOfIgnoreCase(String o2) {
        if (o2 == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!o2.equalsIgnoreCase(this.b[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(String o2) {
        int n2 = this.indexOf(o2);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<String> vector = new Vector<String>(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            vector.addElement(this.b[i2]);
        }
        return vector;
    }

    public final boolean contains(String o2) {
        return this.indexOf(o2) >= 0;
    }

    public final boolean containsIgnoreCase(String o2) {
        return this.indexOfIgnoreCase(o2) >= 0;
    }

    public final String containsDuplicates() {
        for (int i2 = 0; i2 < this.c; ++i2) {
            String string = this.b[i2];
            for (int i3 = i2 + 1; i3 < this.c; ++i3) {
                if (!string.equalsIgnoreCase(this.b[i3])) continue;
                return string;
            }
        }
        return "";
    }

    public final String[] toArray() {
        return this.toArray(new String[this.c]);
    }

    public final String[] toArray(String[] o2) {
        if (o2 == null || o2.length != this.c) {
            o2 = new String[this.c];
        }
        System.arraycopy(this.b, 0, o2, 0, this.c);
        return o2;
    }

    public final void copyInto(String[] o2) {
        if (o2 == null || o2.length != this.c) {
            throw new RuntimeException();
        }
        System.arraycopy(this.b, 0, o2, 0, this.c);
    }

    public final void addAll(String[] o2) {
        if (o2 == null) {
            throw new RuntimeException();
        }
        this.a(this.c + o2.length);
        System.arraycopy(o2, 0, this.b, this.c, o2.length);
        this.c += o2.length;
    }

    public final void addAll(StringList o2) {
        this.a(this.c + o2.c);
        System.arraycopy(o2.b, 0, this.b, this.c, o2.c);
        this.c += o2.c;
    }

    public final void setElementAt(String o2, int index) {
        if (index >= this.c) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.b[index] = o2;
    }

    public final String lastElement() {
        return this.b[this.c - 1];
    }

    public final Object clone() {
        StringList stringList = null;
        try {
            stringList = (StringList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        stringList.b = new String[this.b.length];
        System.arraycopy(this.b, 0, stringList.b, 0, this.c);
        return stringList;
    }

    public final boolean isEmpty() {
        return this.c == 0;
    }

    public final Object getID() {
        return this.a;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',').append(' ');
            }
            stringBuffer.append(this.b[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final Object getObjectAt(int i2) {
        return this.elementAt(i2);
    }

    public final void save(File f2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(f2));
        for (int i2 = 0; i2 < this.c; ++i2) {
            printWriter.println(this.b[i2]);
        }
        printWriter.close();
    }

    public final void load(File f2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(f2));
        String string = bufferedReader.readLine();
        while (string != null) {
            this.addElement(new String(string));
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public final void sort() {
        Arrays.sort(this.b, 0, this.c, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
    }
}

