/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics.buffered;

import com.inet.annotations.InternalApi;
import com.inet.cache.image.RenderingHintLowerImage;
import com.inet.classloader.ObjectStreams;
import com.inet.graphics.buffered.BGClip;
import com.inet.graphics.buffered.BufferedGraphics2D;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.graphics.buffered.GraphicsFilter;
import com.inet.graphics.buffered.GraphicsObjectID;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.HashBiMap;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageIO;

@InternalApi
public class BufferedGraphicsProvider {
    private List<BufferedGraphicsCommand> a;
    private int b = 0;
    private HashBiMap<GraphicsObjectID, AffineTransform> c = new HashBiMap();
    private Map<Integer, BGClip> d = new HashMap<Integer, BGClip>();

    public BufferedGraphicsProvider() {
        this.a = new ArrayList<BufferedGraphicsCommand>();
    }

    public void add(BufferedGraphicsCommand command) {
        this.a.add(command);
    }

    public void add(int graphicsID, BufferedGraphicsCommand.MethodNames name, Object ... params) {
        this.a.add(new BufferedGraphicsCommand(graphicsID, name, params));
    }

    public int getNextGraphicsId() {
        return ++this.b;
    }

    public GraphicsObjectID addToTransformMap(AffineTransform transform) {
        GraphicsObjectID graphicsObjectID = new GraphicsObjectID(this.c.size());
        this.c.put(graphicsObjectID, transform);
        return graphicsObjectID;
    }

    public GraphicsObjectID getFromTransformMap(AffineTransform transform) {
        return this.c.getKey(transform);
    }

    public Integer addToClipMap(Shape s) {
        Integer n2 = this.d.size();
        if (s instanceof BGClip) {
            BGClip bGClip = (BGClip)s;
            if (!Objects.equals(n2, bGClip.getId())) {
                throw new IllegalStateException("Inconsistent clip state: ID " + n2 + " vs. ID " + bGClip.getId());
            }
            s = bGClip.a();
        }
        this.d.put(n2, new BGClip(s, n2));
        return n2;
    }

    public BGClip getClipFromMap(Integer key) {
        return this.d.get(key);
    }

    public boolean hasClipInMap(Integer key) {
        return this.d.containsKey(key);
    }

    public void drawTo(Graphics2D graphics) {
        this.drawTo(graphics, null);
    }

    public void drawTo(Graphics2D graphics, GraphicsFilter filter) {
        HashMap<Integer, LayerGraphics2D> hashMap = new HashMap<Integer, LayerGraphics2D>();
        LayerGraphics2D layerGraphics2D = new LayerGraphics2D();
        if (graphics instanceof LayerGraphics2D) {
            layerGraphics2D = (LayerGraphics2D)graphics;
            if (!layerGraphics2D.hasGraphics()) {
                layerGraphics2D.setGraphics(new BufferedImage(1, 1, 2).createGraphics());
            }
        } else {
            layerGraphics2D.setGraphics(graphics);
        }
        int n2 = 0;
        hashMap.put(n2, layerGraphics2D);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList linkedList2 = new LinkedList();
        linkedList2.add(new HashMap<GraphicsObjectID, AffineTransform>(this.c));
        LinkedList linkedList3 = new LinkedList();
        linkedList3.add(new HashMap<Integer, BGClip>(this.d));
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            int n3;
            BufferedGraphicsCommand bufferedGraphicsCommand = this.a.get(i2);
            if (bufferedGraphicsCommand.getName() == BufferedGraphicsCommand.MethodNames.ADDLAYER) {
                linkedList.add(i2);
                continue;
            }
            if (bufferedGraphicsCommand.getName() == BufferedGraphicsCommand.MethodNames.DRAWLAYER && !linkedList.isEmpty()) {
                Integer n4 = (Integer)linkedList.pollLast();
                if (n4 == null) continue;
                ArrayList<BufferedGraphicsCommand> arrayList = new ArrayList<BufferedGraphicsCommand>(this.a.size() - (i2 - n4 + 1));
                arrayList.addAll(this.a.subList(0, n4));
                arrayList.addAll(this.a.subList(i2 + 1, this.a.size()));
                this.a = arrayList;
                i2 = n4 - 1;
                continue;
            }
            if (linkedList.isEmpty()) {
                n3 = var11_12 = i2;
            } else {
                if (!this.a(bufferedGraphicsCommand)) continue;
                var11_12 = (Integer)linkedList.getFirst();
                n3 = i2;
                linkedList.clear();
            }
            for (int i3 = var11_12; i3 <= n3; ++i3) {
                bufferedGraphicsCommand = this.a.get(i3);
                int n5 = bufferedGraphicsCommand.getId();
                if (n5 != n2) {
                    n2 = n5;
                    layerGraphics2D = (LayerGraphics2D)hashMap.get(n2);
                }
                if (bufferedGraphicsCommand.getName() == BufferedGraphicsCommand.MethodNames.CREATE) {
                    hashMap.put(hashMap.size(), (LayerGraphics2D)layerGraphics2D.create());
                    continue;
                }
                if (filter != null && !filter.canDraw(bufferedGraphicsCommand, graphics)) continue;
                if (bufferedGraphicsCommand.getName() == BufferedGraphicsCommand.MethodNames.ADDLAYER) {
                    linkedList2.addLast(new HashMap((Map)linkedList2.getLast()));
                    linkedList3.addLast(new HashMap((Map)linkedList3.getLast()));
                }
                bufferedGraphicsCommand.run(layerGraphics2D, (Map)linkedList2.getLast(), (Map)linkedList3.getLast());
                if (bufferedGraphicsCommand.getName() == BufferedGraphicsCommand.MethodNames.DRAWLAYER) {
                    linkedList2.pollLast();
                    linkedList3.pollLast();
                }
                if (bufferedGraphicsCommand.getName() != BufferedGraphicsCommand.MethodNames.ADDLAYER) continue;
                ((HashMap)linkedList2.getLast()).put(new GraphicsObjectID(n5), layerGraphics2D.getTransform());
            }
        }
    }

    private boolean a(BufferedGraphicsCommand bufferedGraphicsCommand) {
        String string = bufferedGraphicsCommand.getName().toString();
        return string.contains("FILL") || string.contains("DRAW");
    }

    public void writeTo(DataOutput stream) throws IOException {
        int n2 = 0;
        ArrayList<BufferedGraphicsCommand> arrayList = new ArrayList<BufferedGraphicsCommand>(this.a);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            BufferedGraphicsCommand bufferedGraphicsCommand = (BufferedGraphicsCommand)arrayList.get(i2);
            int n3 = bufferedGraphicsCommand.getId();
            if (n3 != n2) {
                stream.writeInt(BufferedGraphicsCommand.MethodNames.GRAPHICS_SWITCH.ordinal());
                stream.writeInt(n3);
                n2 = n3;
            }
            bufferedGraphicsCommand.writeTo(stream);
        }
        stream.writeInt(BufferedGraphicsCommand.MethodNames.END_FLAG.ordinal());
    }

    public void readFrom(DataInput stream, BufferedGraphics2D bufferedGraphics) {
        HashMap<Integer, BufferedGraphics2D> hashMap = new HashMap<Integer, BufferedGraphics2D>();
        hashMap.put(0, bufferedGraphics);
        BufferedGraphics2D bufferedGraphics2D = bufferedGraphics;
        int n2 = 0;
        BufferedGraphicsCommand.MethodNames methodNames = null;
        try {
            bufferedGraphics2D.a(true);
            boolean bl = true;
            block72: while (bl) {
                methodNames = BufferedGraphicsCommand.MethodNames.values()[stream.readInt()];
                switch (methodNames) {
                    case END_FLAG: {
                        bl = false;
                        continue block72;
                    }
                    case GRAPHICS_SWITCH: {
                        bufferedGraphics2D = (BufferedGraphics2D)hashMap.get(stream.readInt());
                        continue block72;
                    }
                    case CREATE: {
                        hashMap.put(++n2, (BufferedGraphics2D)bufferedGraphics.create());
                        continue block72;
                    }
                    case SET_PAINT_CUSTOM: {
                        bufferedGraphics2D.setPaint((Paint)this.a(stream));
                        continue block72;
                    }
                    case ADD_RENDERING_HINTS: {
                        bufferedGraphics2D.addRenderingHints((Map)this.b(stream));
                        continue block72;
                    }
                    case CLEAR_RECT: {
                        bufferedGraphics2D.clearRect(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case CLIP: {
                        bufferedGraphics2D.clip(this.h(stream));
                        continue block72;
                    }
                    case CLIP_RECT: {
                        bufferedGraphics2D.clipRect(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case COPY_AREA: {
                        bufferedGraphics2D.copyArea(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DISPOSE: {
                        bufferedGraphics2D.dispose();
                        continue block72;
                    }
                    case DRAW: {
                        bufferedGraphics2D.draw(this.h(stream));
                        continue block72;
                    }
                    case DRAW_ARC: {
                        bufferedGraphics2D.drawArc(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_BG: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), stream.readInt(), stream.readInt(), this.d(stream), null);
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_BUFF_IMG: {
                        bufferedGraphics2D.drawImage((BufferedImage)this.readImage(stream), null, stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_CORNER: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), null);
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_CORNER_AND_BG: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), this.d(stream), null);
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_OBS: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), stream.readInt(), stream.readInt(), null);
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_SIZE: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), null);
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_SIZE_AND_BG: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), this.d(stream), null);
                        continue block72;
                    }
                    case DRAW_IMAGE_WITH_XFORM: {
                        bufferedGraphics2D.drawImage(this.readImage(stream), this.f(stream), null);
                        continue block72;
                    }
                    case DRAW_LINE: {
                        bufferedGraphics2D.drawLine(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DRAW_OVAL: {
                        bufferedGraphics2D.drawOval(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DRAW_POLYGON: {
                        bufferedGraphics2D.drawPolygon(this.g(stream), this.g(stream), stream.readInt());
                        continue block72;
                    }
                    case DRAW_POLYLINE: {
                        bufferedGraphics2D.drawPolyline(this.g(stream), this.g(stream), stream.readInt());
                        continue block72;
                    }
                    case DRAW_RENDERABLE_IMAGE: {
                        bufferedGraphics2D.drawRenderableImage((RenderableImage)((Object)this.readImage(stream)), this.f(stream));
                        continue block72;
                    }
                    case DRAW_RENDERED_IMAGE: {
                        bufferedGraphics2D.drawRenderedImage((RenderedImage)((Object)this.readImage(stream)), this.f(stream));
                        continue block72;
                    }
                    case DRAW_ROUND_RECT: {
                        bufferedGraphics2D.drawRoundRect(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DRAW_STRING_WITH_INT: {
                        bufferedGraphics2D.drawString(stream.readUTF(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case DRAW_STRING_WITH_FLOAT: {
                        bufferedGraphics2D.drawString(stream.readUTF(), stream.readFloat(), stream.readFloat());
                        continue block72;
                    }
                    case FILL: {
                        bufferedGraphics2D.fill(this.h(stream));
                        continue block72;
                    }
                    case FILL_ARC: {
                        bufferedGraphics2D.fillArc(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case FILL_OVAL: {
                        bufferedGraphics2D.fillOval(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case FILL_POLYGON: {
                        bufferedGraphics2D.fillPolygon(this.g(stream), this.g(stream), stream.readInt());
                        continue block72;
                    }
                    case FILL_RECT: {
                        bufferedGraphics2D.fillRect(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case FILL_ROUND_RECT: {
                        bufferedGraphics2D.fillRoundRect(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case GET_CLIP: {
                        Integer n3 = stream.readInt();
                        this.add(bufferedGraphics2D.getId(), BufferedGraphicsCommand.MethodNames.GET_CLIP, n3);
                        continue block72;
                    }
                    case HIT: {
                        bufferedGraphics2D.hit(new Rectangle(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt()), this.h(stream), stream.readBoolean());
                        continue block72;
                    }
                    case ROTATE: {
                        bufferedGraphics2D.rotate(stream.readDouble());
                        continue block72;
                    }
                    case ROTATE_WITH_COORDS: {
                        bufferedGraphics2D.rotate(stream.readDouble(), stream.readDouble(), stream.readDouble());
                        continue block72;
                    }
                    case SCALE: {
                        bufferedGraphics2D.scale(stream.readDouble(), stream.readDouble());
                        continue block72;
                    }
                    case SETPAINT: {
                        bufferedGraphics2D.setPaint(this.d(stream));
                        continue block72;
                    }
                    case SET_GRADIENT_PAINT: {
                        bufferedGraphics2D.setPaint(new GradientPaint(stream.readFloat(), stream.readFloat(), this.d(stream), stream.readFloat(), stream.readFloat(), this.d(stream), stream.readBoolean()));
                        continue block72;
                    }
                    case SET_RADIAL_GRADIENT_PAINT: {
                        bufferedGraphics2D.setPaint(new RadialGradientPaint(stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat(), this.c(stream), this.e(stream), MultipleGradientPaint.CycleMethod.values()[stream.readInt()]));
                        continue block72;
                    }
                    case SET_LINEAR_GRADIENT_PAINT: {
                        bufferedGraphics2D.setPaint(new LinearGradientPaint(new Point2D.Float(stream.readFloat(), stream.readFloat()), new Point2D.Float(stream.readFloat(), stream.readFloat()), this.c(stream), this.e(stream), MultipleGradientPaint.CycleMethod.values()[stream.readInt()], MultipleGradientPaint.ColorSpaceType.values()[stream.readInt()], this.f(stream)));
                        continue block72;
                    }
                    case SET_TEXTURE_PAINT: {
                        bufferedGraphics2D.setPaint(new TexturePaint(this.a(this.readImage(stream)), new Rectangle2D.Float(stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat())));
                        continue block72;
                    }
                    case SET_BACKGROUND: {
                        bufferedGraphics2D.setBackground(this.d(stream));
                        continue block72;
                    }
                    case SET_CLIP: {
                        bufferedGraphics2D.setClip(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case SET_CLIP_WITH_SHAPE: {
                        boolean bl2 = stream.readBoolean();
                        if (bl2) {
                            int n4 = stream.readInt();
                            bufferedGraphics2D.setClip(new BGClip(null, n4));
                            continue block72;
                        }
                        bufferedGraphics2D.setClip(this.h(stream));
                        continue block72;
                    }
                    case SET_COLOR: {
                        bufferedGraphics2D.setColor(this.d(stream));
                        continue block72;
                    }
                    case SET_COMPOSITE: {
                        bufferedGraphics2D.setComposite(this.readComposite(stream));
                        continue block72;
                    }
                    case SET_FONT: {
                        bufferedGraphics2D.setFont(this.readFont(stream));
                        continue block72;
                    }
                    case SET_PAINT_MODE: {
                        bufferedGraphics2D.setPaintMode();
                        continue block72;
                    }
                    case SET_RENDERING_HINTS: {
                        bufferedGraphics2D.setRenderingHints(this.b(stream));
                        continue block72;
                    }
                    case SET_RENDERING_HINT: {
                        Map<?, ?> map = this.b(stream);
                        Set<?> set = map.keySet();
                        Object[] objectArray = set.toArray();
                        bufferedGraphics2D.setRenderingHint((RenderingHints.Key)objectArray[0], map.get(objectArray[0]));
                        continue block72;
                    }
                    case SET_STROKE: {
                        bufferedGraphics2D.setStroke(new BasicStroke(stream.readFloat(), stream.readInt(), stream.readInt(), stream.readFloat(), this.c(stream), stream.readFloat()));
                        continue block72;
                    }
                    case SET_TRANSFORM: {
                        bufferedGraphics2D.setTransform((AffineTransform)this.c.get(new GraphicsObjectID(stream.readInt())));
                        continue block72;
                    }
                    case SET_XOR_MODE: {
                        bufferedGraphics2D.setXORMode(this.d(stream));
                        continue block72;
                    }
                    case SHEAR: {
                        bufferedGraphics2D.shear(stream.readDouble(), stream.readDouble());
                        continue block72;
                    }
                    case TRANSFORM: {
                        bufferedGraphics2D.transform(this.f(stream));
                        continue block72;
                    }
                    case TRANSLATE_WITH_DOUBLE: {
                        bufferedGraphics2D.translate(stream.readDouble(), stream.readDouble());
                        continue block72;
                    }
                    case TRANSLATE_WITH_INT: {
                        bufferedGraphics2D.translate(stream.readInt(), stream.readInt());
                        continue block72;
                    }
                    case GET_TRANSFORM: {
                        bufferedGraphics2D.getTransform();
                        continue block72;
                    }
                    case INITIALIZE: {
                        Rectangle2D.Double double_ = new Rectangle2D.Double(stream.readDouble(), stream.readDouble(), stream.readDouble(), stream.readDouble());
                        AffineTransform affineTransform = this.f(stream);
                        bufferedGraphics2D.setInitialInformation(double_, affineTransform);
                        continue block72;
                    }
                    case ADDLAYER: {
                        bufferedGraphics2D.addLayer(stream.readBoolean(), stream.readBoolean(), (BlendComposite)this.readComposite(stream));
                        continue block72;
                    }
                    case DRAWLAYER: {
                        bufferedGraphics2D.paintLastLayer();
                        continue block72;
                    }
                }
                throw new IllegalStateException();
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Konnte nicht aus dem Stream lesen:", iOException);
        }
        finally {
            bufferedGraphics2D.a(false);
        }
    }

    private BufferedImage a(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        bufferedImage.createGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    private Object a(DataInput dataInput) throws IOException {
        try {
            byte[] byArray = new byte[dataInput.readInt()];
            dataInput.readFully(byArray);
            ObjectStreams.CacheObjectInputStream cacheObjectInputStream = new ObjectStreams.CacheObjectInputStream(new ByteArrayInputStream(byArray));
            return cacheObjectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unknown error on reading of an object:", classNotFoundException);
        }
    }

    private Map<?, ?> b(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            RenderingHints.Key key = null;
            Object object = null;
            int n3 = dataInput.readInt();
            int n4 = dataInput.readInt();
            if (n3 == -1 || n4 == -1) continue;
            if (n3 == 0) {
                key = RenderingHints.KEY_ANTIALIASING;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_ANTIALIAS_ON;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_ANTIALIAS_OFF;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
                }
            } else if (n3 == 1) {
                key = RenderingHints.KEY_RENDERING;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_RENDER_SPEED;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_RENDER_QUALITY;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_RENDER_DEFAULT;
                }
            } else if (n3 == 2) {
                key = RenderingHints.KEY_DITHERING;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_DITHER_DISABLE;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_DITHER_ENABLE;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_DITHER_DEFAULT;
                }
            } else if (n3 == 3) {
                key = RenderingHints.KEY_TEXT_ANTIALIASING;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
                } else if (n4 == 3) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                } else if (n4 == 4) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                } else if (n4 == 5) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                } else if (n4 == 6) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
                } else if (n4 == 7) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                }
            } else if (n3 == 4) {
                key = RenderingHints.KEY_TEXT_LCD_CONTRAST;
                object = n4;
            } else if (n3 == 5) {
                key = RenderingHints.KEY_FRACTIONALMETRICS;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_FRACTIONALMETRICS_ON;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
                }
            } else if (n3 == 6) {
                key = RenderingHints.KEY_INTERPOLATION;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                }
            } else if (n3 == 7) {
                key = RenderingHints.KEY_ALPHA_INTERPOLATION;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT;
                }
            } else if (n3 == 8) {
                key = RenderingHints.KEY_COLOR_RENDERING;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_COLOR_RENDER_SPEED;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_COLOR_RENDER_QUALITY;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_COLOR_RENDER_DEFAULT;
                }
            } else if (n3 == 9) {
                key = RenderingHints.KEY_STROKE_CONTROL;
                if (n4 == 0) {
                    object = RenderingHints.VALUE_STROKE_DEFAULT;
                } else if (n4 == 1) {
                    object = RenderingHints.VALUE_STROKE_NORMALIZE;
                } else if (n4 == 2) {
                    object = RenderingHints.VALUE_STROKE_PURE;
                }
            } else {
                if (n3 != 10) continue;
                key = RenderingHintLowerImage.KEY;
                object = n4;
            }
            hashMap.put(key, object);
        }
        return hashMap;
    }

    protected Composite readComposite(DataInput stream) throws IOException {
        byte by = stream.readByte();
        int n2 = stream.readInt();
        float f2 = stream.readFloat();
        Object object = null;
        if (by == 0) {
            object = AlphaComposite.getInstance(n2, f2);
        } else {
            Object object2;
            BlendComposite.BlendingMode blendingMode = BlendComposite.BlendingMode.getBlendingMode(stream.readByte());
            boolean bl = stream.readBoolean();
            BufferedImage bufferedImage = null;
            if (bl) {
                object2 = this.readImage(stream);
                if (!(object2 instanceof BufferedImage) || ((BufferedImage)object2).getType() != 2) {
                    BufferedImage bufferedImage2 = new BufferedImage(((Image)object2).getWidth(null), ((Image)object2).getHeight(null), 2);
                    bufferedImage2.getGraphics().drawImage((Image)object2, 0, 0, null);
                    bufferedImage = bufferedImage2;
                } else {
                    bufferedImage = (BufferedImage)object2;
                }
            }
            object = object2 = new BlendComposite(blendingMode, f2, bufferedImage);
        }
        return object;
    }

    private float[] c(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        float[] fArray = null;
        if (n2 > 0) {
            fArray = new float[n2];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray[i2] = dataInput.readFloat();
            }
        }
        return fArray;
    }

    private Color d(DataInput dataInput) throws IOException {
        return new Color(dataInput.readInt(), true);
    }

    private Color[] e(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        Color[] colorArray = new Color[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            colorArray[i2] = this.d(dataInput);
        }
        return colorArray;
    }

    private AffineTransform f(DataInput dataInput) throws IOException {
        return new AffineTransform(dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble(), dataInput.readDouble());
    }

    protected Image readImage(DataInput stream) throws IOException {
        byte[] byArray = new byte[stream.readInt()];
        stream.readFully(byArray);
        return ImageIO.read(new ByteArrayInputStream(byArray));
    }

    private int[] g(DataInput dataInput) throws IOException {
        int[] nArray = new int[dataInput.readInt()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = dataInput.readInt();
        }
        return nArray;
    }

    private Shape h(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        if (n2 == -1) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(n2);
        while (true) {
            int n3 = dataInput.readInt();
            switch (n3) {
                case -1: {
                    return generalPath;
                }
                case 0: {
                    generalPath.moveTo(dataInput.readFloat(), dataInput.readFloat());
                    break;
                }
                case 1: {
                    generalPath.lineTo(dataInput.readFloat(), dataInput.readFloat());
                    break;
                }
                case 2: {
                    generalPath.quadTo(dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
                    break;
                }
                case 3: {
                    generalPath.curveTo(dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
                    break;
                }
                case 4: {
                    generalPath.closePath();
                }
            }
        }
    }

    protected Font readFont(DataInput stream) throws IOException {
        return new Font(stream.readUTF(), stream.readInt(), stream.readInt());
    }

    public void dump(PrintStream out) {
        out.println("=== BufferedGraphics: " + this.a.size() + " commands ===");
        for (BufferedGraphicsCommand bufferedGraphicsCommand : this.a) {
            out.println("  " + String.valueOf(bufferedGraphicsCommand));
        }
    }

    public List<BufferedGraphicsCommand> getList() {
        return this.a;
    }
}

