/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeInteger
extends FieldType<Integer> {
    public FieldTypeInteger(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.Integer, true, TextSearchTokenizer.DEFAULT, 100, labelProvider, true));
    }

    public static FieldTypeInteger withoutSearchtag(String key) {
        return new FieldTypeInteger(key, () -> null){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public Integer valueOf(@Nullable String value) {
        if (StringFunctions.isEmpty(value)) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(Field.MSG.getMsg("field.warning.illegalvalue", this.getKey(), value));
        }
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.LESS_THAN, FieldOperator.GREATER_THAN, FieldOperator.GREATER_OR_EQUAL, FieldOperator.LESS_OR_EQUAL, FieldOperator.IS_NOT_EMPTY);
    }
}

