/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.provider;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.internal.PrivateCloudLicenseTimerTask;
import com.inet.config.structure.core.license.LicenseConfigProperty;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.lib.json.Json;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigStructureSettings {
    @Nonnull
    private final Configuration a;
    @Nonnull
    private final Locale b;
    @Nullable
    private final Properties c;
    @Nonnull
    private LicenseInfo d;
    private boolean e;

    public ConfigStructureSettings(@Nonnull Configuration configuration, @Nonnull Locale locale, @Nullable Properties values) {
        this(configuration, locale, values, false);
    }

    public ConfigStructureSettings(@Nonnull Configuration configuration, @Nonnull Locale locale, @Nullable Properties values, boolean isFilter) {
        this.a = configuration;
        this.b = locale;
        this.c = values;
        this.d = this.generateLicenseInfo();
        this.e = isFilter;
    }

    @Nonnull
    protected LicenseInfo generateLicenseInfo() {
        return new ConfigKeyParser().getLicenseInfo(this.getLicenseKey()).getCurrent();
    }

    public String getLicenseKey() {
        String string;
        Properties properties = this.getValues();
        if (properties != null && (string = properties.getProperty(ConfigKey.LICENSEKEY.getKey())) != null) {
            try {
                String string2 = this.getValue(ConfigKey.SERVER_URL);
                URL uRL = new URL(string2);
                if (!PrivateCloudLicenseTimerTask.isKnown(uRL)) {
                    for (int i2 = 0; i2 < 20 && PrivateCloudLicenseTimerTask.externalUrlAssignable(uRL) != null; ++i2) {
                        Thread.sleep(1L);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return LicenseConfigProperty.convertToLicenseList(string);
        }
        return this.getOriginalValue(ConfigKey.LICENSEKEY);
    }

    public void setLicenseKey(String licenseKey) {
        this.c.setProperty(ConfigKey.LICENSEKEY.getKey(), licenseKey);
        this.d = this.generateLicenseInfo();
    }

    public void save(ConfigKey configKey, String value) {
        this.save(configKey.getKey(), value);
    }

    public void save(String key, String value) {
        this.a.put(key, value);
    }

    public String getOriginalValue(ConfigKey configKey) {
        return this.a.get(configKey);
    }

    public String getValue(ConfigKey key) {
        return this.a(key, key.getKey());
    }

    public String getValue(@Nonnull String key) {
        return this.a(null, key);
    }

    private String a(@Nullable ConfigKey configKey, @Nonnull String string) {
        Properties properties = this.c;
        String string2 = properties != null && properties.containsKey(string) ? properties.getProperty(string) : this.a.get(string);
        if (string2 == null) {
            if (configKey == null) {
                configKey = ConfigKey.valueOf(string);
            }
            if (configKey != null) {
                return configKey.getDefault();
            }
        } else if ("".equals(string2)) {
            if (configKey == null) {
                configKey = ConfigKey.valueOf(string);
            }
            if (configKey != null && (Number.class.isAssignableFrom(configKey.getType()) || Boolean.class.isAssignableFrom(configKey.getType()))) {
                return configKey.getDefault();
            }
        }
        return string2;
    }

    @Nullable
    public <T> T getChangedValue(ConfigKey key, Class<T> clazz) {
        return this.getChangedValue(key.getKey(), clazz);
    }

    @Nullable
    public <T> T getChangedValue(String key, Class<T> clazz) {
        String string;
        Properties properties = this.c;
        if (properties != null && (string = properties.getProperty(key)) != null) {
            return new Json().fromJson(string, clazz);
        }
        return null;
    }

    @Nullable
    public <T> T getValue(String key, Class<T> clazz) {
        String string = this.getValue(key);
        if (string != null) {
            return new Json().fromJson(string, clazz);
        }
        return null;
    }

    @Nullable
    public <T> T getValue(ConfigKey key, Class<T> clazz) {
        String string = this.getValue(key);
        if (string != null) {
            return new Json().fromJson(string, clazz);
        }
        return null;
    }

    public String getChangedValue(String key) {
        if (this.c != null) {
            return this.c.getProperty(key);
        }
        return null;
    }

    public Set<String> keySet() {
        Set<Object> set = this.a.getProperties().keySet();
        return set;
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    @Nonnull
    public Locale getLocale() {
        return this.b;
    }

    public LicenseInfo getLicense() {
        return this.d;
    }

    public boolean isPlus() {
        return this.d.isValid() && Boolean.parseBoolean(this.d.getAttributes().get("crplus"));
    }

    @Nullable
    public Properties getValues() {
        return this.c;
    }

    public boolean isValidatable(ConfigKey key, @Nonnull List<ConfigConditionAction> conditions) {
        return this.isEnabled(key.getKey(), conditions) && this.isVisible(key.getKey(), conditions);
    }

    public boolean isVisible(String key, @Nonnull List<ConfigConditionAction> conditions) {
        boolean bl = true;
        if (conditions != null) {
            for (ConfigConditionAction configConditionAction : conditions) {
                if (!key.equals(configConditionAction.getKey())) continue;
                switch (configConditionAction.getAction()) {
                    case Visible: {
                        bl = this.evalCondition(configConditionAction.getCondition());
                        break;
                    }
                }
            }
        }
        return bl;
    }

    public boolean isEnabled(String key, @Nonnull List<ConfigConditionAction> conditions) {
        boolean bl = true;
        if (conditions != null) {
            for (ConfigConditionAction configConditionAction : conditions) {
                if (!key.equals(configConditionAction.getKey())) continue;
                switch (configConditionAction.getAction()) {
                    case Enable: {
                        bl = this.evalCondition(configConditionAction.getCondition());
                        break;
                    }
                }
            }
        }
        return bl;
    }

    public boolean evalCondition(ConfigCondition condition) {
        Object[] objectArray = condition.getParams();
        switch (condition.getOp()) {
            case Equals: {
                return this.getValue((String)objectArray[0]).equals(objectArray[1]);
            }
            case And: {
                boolean bl = true;
                for (Object object : objectArray) {
                    bl &= this.evalCondition((ConfigCondition)object);
                }
                return bl;
            }
            case Or: {
                boolean bl = false;
                for (Object object : objectArray) {
                    bl |= this.evalCondition((ConfigCondition)object);
                }
                return bl;
            }
            case Not: {
                return !this.evalCondition((ConfigCondition)objectArray[0]);
            }
            case GT: {
                String string;
                String string2 = this.getValue((String)objectArray[0]);
                if (string2.length() == 0) {
                    string2 = "0";
                }
                if ((string = (String)objectArray[1]).length() == 0) {
                    string = "0";
                }
                try {
                    return Float.parseFloat(string2) > Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case LT: {
                String string;
                String string3 = this.getValue((String)objectArray[0]);
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if ((string = (String)objectArray[1]).length() == 0) {
                    string = "0";
                }
                try {
                    return Float.parseFloat(string3) < Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case True: {
                return true;
            }
            case False: {
                return false;
            }
            case IsIn: {
                String string = this.getValue((String)objectArray[0]);
                String string4 = (String)objectArray[1];
                String[] stringArray = new Json().fromJson(string4, String[].class);
                return Arrays.asList(stringArray).contains(string);
            }
        }
        throw new IllegalStateException("Unknown operation: " + String.valueOf((Object)condition.getOp()));
    }

    public boolean isCurrentConfigurationSelected() {
        boolean bl;
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        Configuration configuration2 = this.getConfiguration();
        boolean bl2 = bl = configuration != null && configuration.getScope() == configuration2.getScope() && configuration.getName().equals(configuration2.getName());
        if (configuration2.getScope() == 4) {
            bl &= configuration2 == configuration;
        }
        return bl;
    }

    public boolean isFilter() {
        return this.e;
    }
}

