/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.model;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class TreeConfigPropertyNode
extends LocalizedKey
implements Comparable<TreeConfigPropertyNode>,
Iterable<TreeConfigPropertyNode> {
    private HashMap details;
    private List<TreeConfigPropertyNode> nodes;

    private TreeConfigPropertyNode() {
        super(null, null);
    }

    public TreeConfigPropertyNode(@Nonnull String key, String label, HashMap details) {
        super(key, label);
        this.details = details;
    }

    public void add(TreeConfigPropertyNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<TreeConfigPropertyNode>();
        }
        this.nodes.add(node);
    }

    @Override
    public Iterator<TreeConfigPropertyNode> iterator() {
        if (this.nodes == null) {
            return Collections.emptyIterator();
        }
        return this.nodes.iterator();
    }

    public HashMap getDetails() {
        return this.details;
    }

    public void sort() {
        if (this.nodes != null) {
            Collections.sort(this.nodes);
            for (TreeConfigPropertyNode treeConfigPropertyNode : this.nodes) {
                treeConfigPropertyNode.sort();
            }
        }
    }

    @Nullable
    public List<TreeConfigPropertyNode> getNodes() {
        return this.nodes;
    }

    @Override
    public int compareTo(TreeConfigPropertyNode o2) {
        if (this.nodes == null && o2.nodes != null) {
            return 1;
        }
        if (this.nodes != null && o2.nodes == null) {
            return -1;
        }
        String string = this.getDisplayName() == null ? this.getKey() : this.getDisplayName();
        String string2 = o2.getDisplayName() == null ? o2.getKey() : o2.getDisplayName();
        return string.compareTo(string2);
    }
}

