/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.annotations.PublicApi;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationChangeListener;
import com.inet.config.ConfigurationManagerImpl;
import com.inet.config.ConfigurationMigrator;
import com.inet.lib.util.PreferencesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class ConfigurationManager {
    static final String NAME_TEMP = "Temp";
    static final String NAME_USER = "User";
    static final String NAME_SYSTEM = "System";
    private static ConfigurationManager a;
    private static boolean b;
    private static boolean c;
    private static String d;
    public static String NAME_DEFAULT;
    public static final String NAME_TEMP_DEFAULT = "<temporary default>";
    public static final String COMMAND_LINE_CONFIG_PROPERTY = "clearreports.config";
    public static boolean ISINIT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationManager getInstance() {
        if (a != null) return a;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (a != null) return a;
            a = new ConfigurationManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    static void a() {
        if (a != null) {
            a.stopImpl();
        }
    }

    abstract void stopImpl();

    public abstract void copy(int var1, String var2, int var3, String var4) throws SecurityException;

    @Nonnull
    public abstract Configuration create(int var1, String var2) throws SecurityException;

    public abstract void delete(Configuration var1) throws SecurityException;

    public abstract void delete(int var1, String var2) throws SecurityException;

    public abstract void exportToStream(int var1, String var2, OutputStream var3) throws SecurityException, IOException;

    @Nullable
    public Configuration get(String fullName) throws SecurityException {
        int n2 = fullName.indexOf(47);
        if (n2 < 0) {
            throw new IllegalArgumentException("The configuration name must be in the format scope/name, e.g. User/myConfig");
        }
        String string = fullName.substring(0, n2);
        String string2 = fullName.substring(n2 + 1);
        int n3 = -1;
        if (string.equalsIgnoreCase(NAME_USER)) {
            n3 = 2;
        } else if (string.equalsIgnoreCase(NAME_SYSTEM)) {
            n3 = 1;
        } else if (string.equalsIgnoreCase(NAME_TEMP)) {
            n3 = 4;
        }
        return this.get(n3, string2);
    }

    @Nullable
    public abstract Configuration get(int var1, String var2) throws SecurityException;

    public abstract Configuration[] getAll(int var1);

    public abstract InetAddress[] getAvailableIPAddresses();

    public abstract void setCurrent(Configuration var1);

    @Nonnull
    public abstract Configuration getCurrent();

    public abstract void importFromStream(int var1, String var2, InputStream var3) throws SecurityException, IOException;

    public abstract void put(int var1, String var2, Configuration var3) throws SecurityException;

    public abstract void rename(int var1, String var2, int var3, String var4) throws SecurityException;

    public abstract Configuration setTemporaryProperties(Properties var1);

    public abstract Configuration setTemporaryPropertiesFromURL(URL var1) throws IOException;

    public static boolean isReadable(int scope) {
        try {
            switch (scope) {
                case 1: {
                    return PreferencesUtils.isSystemReadable("/com/inet/report/config/cc");
                }
                case 2: {
                    return PreferencesUtils.isUserReadable("/com/inet/report/config/cc");
                }
                case 4: {
                    return true;
                }
            }
            throw new IllegalArgumentException(String.valueOf(scope));
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isWriteable(int scope) {
        try {
            switch (scope) {
                case 1: {
                    return PreferencesUtils.isSystemWriteable("/com/inet/report/config/cc");
                }
                case 2: {
                    return PreferencesUtils.isUserWriteable("/com/inet/report/config/cc");
                }
                case 4: {
                    return true;
                }
            }
            throw new IllegalArgumentException(String.valueOf(scope));
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getScopeName(int scope) {
        StringBuffer stringBuffer = new StringBuffer();
        if (scope == 1) {
            stringBuffer.append(NAME_SYSTEM);
        }
        if (scope == 2) {
            stringBuffer.append(NAME_USER);
        }
        if (scope == 4) {
            stringBuffer.append(NAME_TEMP);
        }
        return stringBuffer.toString();
    }

    public abstract void addConfigurationChangeListener(ConfigurationChangeListener var1);

    public abstract void removeConfigurationChangeListener(ConfigurationChangeListener var1);

    public abstract void addConfigurationMigrator(ConfigurationMigrator var1);

    public abstract void removeConfigurationMigrator(ConfigurationMigrator var1);

    public static boolean isRecoveryMode() {
        return b;
    }

    public static void setRecoveryMode(boolean mode) {
        b = mode;
    }

    public static boolean isHelpCenterMode() {
        return c;
    }

    public static void setHelpCenterMode(boolean mode) {
        c = mode;
    }

    @Nullable
    public static String getRecoveryConfiguration() {
        return d;
    }

    public static void setRecoveryConfiguration(String configuration) {
        d = configuration;
    }

    static {
        NAME_DEFAULT = "Default";
    }
}

