/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.http.servlet.ClientLocale;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class I18nMessages {
    private final String a;
    private Object b;

    public I18nMessages(String bundleName, Object caller) throws IllegalArgumentException {
        if (bundleName.contains("/")) {
            throw new IllegalArgumentException(bundleName);
        }
        this.a = bundleName;
        this.b = caller;
        ForkJoinPool.commonPool().execute(() -> {
            try {
                if (ServerPluginManager.getInstance().getCorePluginId() != null) {
                    this.getBundle();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Nonnull
    public String getMsgAllowMissing(String key, Object ... params) {
        return this.getMsg_(ClientLocale.getThreadLocale(), key, true, params);
    }

    @Nonnull
    public String getMsg(String key, Object ... params) {
        return this.getMsg(ClientLocale.getThreadLocale(), key, params);
    }

    @Nonnull
    public String getMsg(Locale locale, String key, Object ... params) {
        return this.getMsg_(locale, key, false, params);
    }

    @Nullable
    public String getMsg_(Locale locale, String key, boolean allowMissingValue, Object ... params) {
        String string;
        try {
            ResourceBundle resourceBundle = this.getBundle(locale);
            string = resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            if (allowMissingValue) {
                return null;
            }
            LogManager.getConfigLogger().warn(missingResourceException);
            return "$" + key + "$";
        }
        try {
            return MessageFormat.format(string, params);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogManager.getConfigLogger().warn(illegalArgumentException);
            return "$" + key + "$";
        }
    }

    @Nonnull
    public ResourceBundle getBundle() {
        return this.getBundle(ClientLocale.getThreadLocale());
    }

    @Nonnull
    public ResourceBundle getBundle(Locale locale) {
        return LoaderUtils.getBundle(this.a, locale, this.b);
    }

    public boolean hasMsg(String msgKey, Locale locale) {
        try {
            ResourceBundle resourceBundle = this.getBundle(locale);
            resourceBundle.getString(msgKey);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }
}

