/*
 * Decompiled with CFR 0.152.
 */
package com.inet.beans.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.inet.beans.zxing.ZxingBarCodes;
import com.inet.beans.zxing.ZxingBarcodeFormat;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.HashMap;

public class ZxingFormatEditor
extends PropertyEditorSupport {
    private static final HashMap<String, ZxingBarcodeFormat> FORMATS = new HashMap();

    @Override
    public String getAsText() {
        ZxingBarcodeFormat value;
        try {
            value = (ZxingBarcodeFormat)this.getValue();
        }
        catch (Throwable e) {
            value = null;
        }
        if (value == null) {
            value = ZxingBarCodes.DEFAULT;
        }
        return value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            ZxingBarcodeFormat value = FORMATS.get(text);
            if (value != null) {
                this.setValue(value);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValue(ZxingBarCodes.DEFAULT);
    }

    @Override
    public String[] getTags() {
        ArrayList<String> tags = new ArrayList<String>(FORMATS.keySet());
        tags.sort(null);
        return tags.toArray(new String[tags.size()]);
    }

    private static boolean encoderExists(BarcodeFormat format) {
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            writer.encode("1234", format, 50, 50);
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            if (msg != null && msg.contains("No encoder")) {
                return false;
            }
        }
        catch (WriterException writerException) {
            // empty catch block
        }
        return true;
    }

    static {
        BarcodeFormat[] formats = BarcodeFormat.values();
        for (int i = 0; i < formats.length; ++i) {
            BarcodeFormat format = formats[i];
            if (!ZxingFormatEditor.encoderExists(format)) continue;
            ZxingBarcodeFormat zFormat = new ZxingBarcodeFormat(format);
            FORMATS.put(zFormat.toString(), zFormat);
        }
        ZxingBarcodeFormat zFormat = new ZxingBarcodeFormat(BarcodeFormat.DATA_MATRIX, "GS1 DATA MATRIX");
        FORMATS.put(zFormat.toString(), zFormat);
    }
}

