/*
 * Decompiled with CFR 0.152.
 */
package com.inet.beans.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.inet.beans.zxing.ZxingBarcodeFormat;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class ZxingBarCodes
extends Component {
    static final String GS1_DATA_MATRIX = "GS1 DATA MATRIX";
    static final ZxingBarcodeFormat DEFAULT = new ZxingBarcodeFormat(BarcodeFormat.QR_CODE);
    private MultiFormatWriter writer;
    private String text = "This is a barcode.";
    private ZxingBarcodeFormat format = DEFAULT;

    public ZxingBarCodes() {
        this.writer = new MultiFormatWriter();
    }

    @Override
    public void paint(Graphics g) {
        try {
            int iHeight;
            BufferedImage image;
            int iWidth;
            int scale;
            Color background;
            if (this.text == null || this.text.equals("")) {
                return;
            }
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            for (int i = 0; i < this.text.length(); ++i) {
                int ch = this.text.charAt(i);
                if (ch <= 255) continue;
                hints.put(EncodeHintType.CHARACTER_SET, "UTF8");
                break;
            }
            hints.put(EncodeHintType.MARGIN, 0);
            switch (this.format.toString()) {
                case "GS1 DATA MATRIX": {
                    hints.put(EncodeHintType.DATA_MATRIX_COMPACT, "true");
                    hints.put(EncodeHintType.GS1_FORMAT, "true");
                }
            }
            int width = this.getWidth();
            int height = this.getHeight();
            BitMatrix bitMatrix = this.writer.encode(this.text, this.format.getFormat(), width, height, hints);
            Color foreground = this.getForeground();
            if (foreground == null) {
                foreground = Color.BLACK;
            }
            if ((background = this.getBackground()) == null) {
                background = Color.WHITE;
            }
            if ((scale = Math.min(width / (iWidth = (image = MatrixToImageWriter.toBufferedImage(bitMatrix, new MatrixToImageConfig(foreground.getRGB(), background.getRGB()))).getWidth()), height / (iHeight = image.getHeight()))) > 1) {
                iWidth *= scale;
                iHeight *= scale;
            }
            int xOffset = (width - iWidth) / 2;
            int yOffset = (height - iHeight) / 2;
            g.drawImage(image, xOffset, yOffset, iWidth, iHeight, null);
        }
        catch (Exception ex) {
            LogManager.getLogger((String)"Reporting").error((Throwable)ex);
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.BLACK);
            g.drawString(StringFunctions.getUserFriendlyErrorMessage((Throwable)ex), 0, this.getHeight() / 2);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ZxingBarcodeFormat getFormat() {
        return this.format;
    }

    public void setFormat(ZxingBarcodeFormat format) {
        if (format == null) {
            format = DEFAULT;
        }
        this.format = format;
    }
}

