/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelDriver;
import com.inet.excel.ExcelSheetResultSet;
import com.inet.excel.parser.ExcelParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;

class ExcelStatement
implements Statement {
    private final ExcelParser parser;
    private boolean closed;
    private ExcelSheetResultSet resultSet;

    ExcelStatement(ExcelParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser must not be null");
        }
        this.parser = parser;
    }

    ExcelParser getParser() {
        return this.parser;
    }

    String getSheetName(String sql) throws SQLException {
        Objects.requireNonNull(sql, "sql is null");
        if (sql.startsWith("{call ")) {
            if (sql.endsWith("()}")) {
                return sql.substring(6, sql.length() - 3);
            }
            if (sql.endsWith("}")) {
                return sql.substring(6, sql.length() - 1);
            }
        }
        throw new SQLException("Unsupported SQL Syntax. Only {call sheetname()} or {call sheetname} are supported: " + sql);
    }

    void throwIfAlreadyClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement: already closed");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.throwIfAlreadyClosed();
        return new ExcelSheetResultSet(this.getParser(), this.getSheetName(sql), 50);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getMaxRows() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void cancel() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.throwIfAlreadyClosed();
        this.resultSet = new ExcelSheetResultSet(this.getParser(), this.getSheetName(sql), 50);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ExcelSheetResultSet rs = this.resultSet;
        this.resultSet = null;
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.resultSet != null;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int getFetchSize() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public void clearBatch() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return false;
    }
}

